/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.WorkweekConfig;
import java.util.List;
import java.util.Objects;

public class UpdateWorkweekConfigResponse {
    private HttpContext httpContext;
    private final WorkweekConfig workweekConfig;
    private final List<Error> errors;

    @JsonCreator
    public UpdateWorkweekConfigResponse(@JsonProperty(value="workweek_config") WorkweekConfig workweekConfig, @JsonProperty(value="errors") List<Error> errors) {
        this.workweekConfig = workweekConfig;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="workweek_config")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public WorkweekConfig getWorkweekConfig() {
        return this.workweekConfig;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.workweekConfig, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateWorkweekConfigResponse)) {
            return false;
        }
        UpdateWorkweekConfigResponse other = (UpdateWorkweekConfigResponse)obj;
        return Objects.equals(this.workweekConfig, other.workweekConfig) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "UpdateWorkweekConfigResponse [workweekConfig=" + this.workweekConfig + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().workweekConfig(this.getWorkweekConfig()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private WorkweekConfig workweekConfig;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder workweekConfig(WorkweekConfig workweekConfig) {
            this.workweekConfig = workweekConfig;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public UpdateWorkweekConfigResponse build() {
            UpdateWorkweekConfigResponse model = new UpdateWorkweekConfigResponse(this.workweekConfig, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

