/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CustomAttribute;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpsertLocationCustomAttributeResponse {
    private HttpContext httpContext;
    private final CustomAttribute customAttribute;
    private final List<Error> errors;

    @JsonCreator
    public UpsertLocationCustomAttributeResponse(@JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="errors") List<Error> errors) {
        this.customAttribute = customAttribute;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="custom_attribute")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.customAttribute, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpsertLocationCustomAttributeResponse)) {
            return false;
        }
        UpsertLocationCustomAttributeResponse other = (UpsertLocationCustomAttributeResponse)obj;
        return Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "UpsertLocationCustomAttributeResponse [customAttribute=" + this.customAttribute + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customAttribute(this.getCustomAttribute()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private CustomAttribute customAttribute;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public UpsertLocationCustomAttributeResponse build() {
            UpsertLocationCustomAttributeResponse model = new UpsertLocationCustomAttributeResponse(this.customAttribute, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

