/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Snippet;
import java.util.List;
import java.util.Objects;

public class UpsertSnippetResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Snippet snippet;

    @JsonCreator
    public UpsertSnippetResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="snippet") Snippet snippet) {
        this.errors = errors;
        this.snippet = snippet;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="snippet")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Snippet getSnippet() {
        return this.snippet;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.snippet);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpsertSnippetResponse)) {
            return false;
        }
        UpsertSnippetResponse other = (UpsertSnippetResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.snippet, other.snippet);
    }

    public String toString() {
        return "UpsertSnippetResponse [errors=" + this.errors + ", snippet=" + this.snippet + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).snippet(this.getSnippet());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Snippet snippet;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder snippet(Snippet snippet) {
            this.snippet = snippet;
            return this;
        }

        public UpsertSnippetResponse build() {
            UpsertSnippetResponse model = new UpsertSnippetResponse(this.errors, this.snippet);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

