/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class V1Device {
    private final String id;
    private final OptionalNullable<String> name;

    @JsonCreator
    public V1Device(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name) {
        this.id = id;
        this.name = OptionalNullable.of((Object)name);
    }

    protected V1Device(String id, OptionalNullable<String> name) {
        this.id = id;
        this.name = name;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1Device)) {
            return false;
        }
        V1Device other = (V1Device)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "V1Device [id=" + this.id + ", name=" + this.name + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId());
        builder.name = this.internalGetName();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<String> name;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public V1Device build() {
            return new V1Device(this.id, this.name);
        }
    }
}

