/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class V1ListSettlementsRequest {
    private final String order;
    private final OptionalNullable<String> beginTime;
    private final OptionalNullable<String> endTime;
    private final OptionalNullable<Integer> limit;
    private final String status;
    private final OptionalNullable<String> batchToken;

    @JsonCreator
    public V1ListSettlementsRequest(@JsonProperty(value="order") String order, @JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="status") String status, @JsonProperty(value="batch_token") String batchToken) {
        this.order = order;
        this.beginTime = OptionalNullable.of((Object)beginTime);
        this.endTime = OptionalNullable.of((Object)endTime);
        this.limit = OptionalNullable.of((Object)limit);
        this.status = status;
        this.batchToken = OptionalNullable.of((Object)batchToken);
    }

    protected V1ListSettlementsRequest(String order, OptionalNullable<String> beginTime, OptionalNullable<String> endTime, OptionalNullable<Integer> limit, String status, OptionalNullable<String> batchToken) {
        this.order = order;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.limit = limit;
        this.status = status;
        this.batchToken = batchToken;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrder() {
        return this.order;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBeginTime() {
        return this.beginTime;
    }

    @JsonIgnore
    public String getBeginTime() {
        return (String)OptionalNullable.getFrom(this.beginTime);
    }

    @JsonGetter(value="end_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndTime() {
        return this.endTime;
    }

    @JsonIgnore
    public String getEndTime() {
        return (String)OptionalNullable.getFrom(this.endTime);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="batch_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBatchToken() {
        return this.batchToken;
    }

    @JsonIgnore
    public String getBatchToken() {
        return (String)OptionalNullable.getFrom(this.batchToken);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.beginTime, this.endTime, this.limit, this.status, this.batchToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1ListSettlementsRequest)) {
            return false;
        }
        V1ListSettlementsRequest other = (V1ListSettlementsRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.limit, other.limit) && Objects.equals(this.status, other.status) && Objects.equals(this.batchToken, other.batchToken);
    }

    public String toString() {
        return "V1ListSettlementsRequest [order=" + this.order + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", status=" + this.status + ", batchToken=" + this.batchToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().order(this.getOrder()).status(this.getStatus());
        builder.beginTime = this.internalGetBeginTime();
        builder.endTime = this.internalGetEndTime();
        builder.limit = this.internalGetLimit();
        builder.batchToken = this.internalGetBatchToken();
        return builder;
    }

    public static class Builder {
        private String order;
        private OptionalNullable<String> beginTime;
        private OptionalNullable<String> endTime;
        private OptionalNullable<Integer> limit;
        private String status;
        private OptionalNullable<String> batchToken;

        public Builder order(String order) {
            this.order = order;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = OptionalNullable.of((Object)beginTime);
            return this;
        }

        public Builder unsetBeginTime() {
            this.beginTime = null;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = OptionalNullable.of((Object)endTime);
            return this;
        }

        public Builder unsetEndTime() {
            this.endTime = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder batchToken(String batchToken) {
            this.batchToken = OptionalNullable.of((Object)batchToken);
            return this;
        }

        public Builder unsetBatchToken() {
            this.batchToken = null;
            return this;
        }

        public V1ListSettlementsRequest build() {
            return new V1ListSettlementsRequest(this.order, this.beginTime, this.endTime, this.limit, this.status, this.batchToken);
        }
    }
}

