/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class V1Money {
    private final OptionalNullable<Integer> amount;
    private final String currencyCode;

    @JsonCreator
    public V1Money(@JsonProperty(value="amount") Integer amount, @JsonProperty(value="currency_code") String currencyCode) {
        this.amount = OptionalNullable.of((Object)amount);
        this.currencyCode = currencyCode;
    }

    protected V1Money(OptionalNullable<Integer> amount, String currencyCode) {
        this.amount = amount;
        this.currencyCode = currencyCode;
    }

    @JsonGetter(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetAmount() {
        return this.amount;
    }

    @JsonIgnore
    public Integer getAmount() {
        return (Integer)OptionalNullable.getFrom(this.amount);
    }

    @JsonGetter(value="currency_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currencyCode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1Money)) {
            return false;
        }
        V1Money other = (V1Money)obj;
        return Objects.equals(this.amount, other.amount) && Objects.equals(this.currencyCode, other.currencyCode);
    }

    public String toString() {
        return "V1Money [amount=" + this.amount + ", currencyCode=" + this.currencyCode + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().currencyCode(this.getCurrencyCode());
        builder.amount = this.internalGetAmount();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Integer> amount;
        private String currencyCode;

        public Builder amount(Integer amount) {
            this.amount = OptionalNullable.of((Object)amount);
            return this;
        }

        public Builder unsetAmount() {
            this.amount = null;
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public V1Money build() {
            return new V1Money(this.amount, this.currencyCode);
        }
    }
}

