/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Address;
import com.squareup.square.models.Error;
import com.squareup.square.models.V1Money;
import com.squareup.square.models.V1OrderHistoryEntry;
import com.squareup.square.models.V1Tender;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class V1Order {
    private HttpContext httpContext;
    private final OptionalNullable<List<Error>> errors;
    private final String id;
    private final OptionalNullable<String> buyerEmail;
    private final OptionalNullable<String> recipientName;
    private final OptionalNullable<String> recipientPhoneNumber;
    private final String state;
    private final Address shippingAddress;
    private final V1Money subtotalMoney;
    private final V1Money totalShippingMoney;
    private final V1Money totalTaxMoney;
    private final V1Money totalPriceMoney;
    private final V1Money totalDiscountMoney;
    private final String createdAt;
    private final String updatedAt;
    private final OptionalNullable<String> expiresAt;
    private final OptionalNullable<String> paymentId;
    private final OptionalNullable<String> buyerNote;
    private final OptionalNullable<String> completedNote;
    private final OptionalNullable<String> refundedNote;
    private final OptionalNullable<String> canceledNote;
    private final V1Tender tender;
    private final OptionalNullable<List<V1OrderHistoryEntry>> orderHistory;
    private final OptionalNullable<String> promoCode;
    private final OptionalNullable<String> btcReceiveAddress;
    private final OptionalNullable<Double> btcPriceSatoshi;

    @JsonCreator
    public V1Order(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="id") String id, @JsonProperty(value="buyer_email") String buyerEmail, @JsonProperty(value="recipient_name") String recipientName, @JsonProperty(value="recipient_phone_number") String recipientPhoneNumber, @JsonProperty(value="state") String state, @JsonProperty(value="shipping_address") Address shippingAddress, @JsonProperty(value="subtotal_money") V1Money subtotalMoney, @JsonProperty(value="total_shipping_money") V1Money totalShippingMoney, @JsonProperty(value="total_tax_money") V1Money totalTaxMoney, @JsonProperty(value="total_price_money") V1Money totalPriceMoney, @JsonProperty(value="total_discount_money") V1Money totalDiscountMoney, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="expires_at") String expiresAt, @JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="buyer_note") String buyerNote, @JsonProperty(value="completed_note") String completedNote, @JsonProperty(value="refunded_note") String refundedNote, @JsonProperty(value="canceled_note") String canceledNote, @JsonProperty(value="tender") V1Tender tender, @JsonProperty(value="order_history") List<V1OrderHistoryEntry> orderHistory, @JsonProperty(value="promo_code") String promoCode, @JsonProperty(value="btc_receive_address") String btcReceiveAddress, @JsonProperty(value="btc_price_satoshi") Double btcPriceSatoshi) {
        this.errors = OptionalNullable.of(errors);
        this.id = id;
        this.buyerEmail = OptionalNullable.of((Object)buyerEmail);
        this.recipientName = OptionalNullable.of((Object)recipientName);
        this.recipientPhoneNumber = OptionalNullable.of((Object)recipientPhoneNumber);
        this.state = state;
        this.shippingAddress = shippingAddress;
        this.subtotalMoney = subtotalMoney;
        this.totalShippingMoney = totalShippingMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalPriceMoney = totalPriceMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.expiresAt = OptionalNullable.of((Object)expiresAt);
        this.paymentId = OptionalNullable.of((Object)paymentId);
        this.buyerNote = OptionalNullable.of((Object)buyerNote);
        this.completedNote = OptionalNullable.of((Object)completedNote);
        this.refundedNote = OptionalNullable.of((Object)refundedNote);
        this.canceledNote = OptionalNullable.of((Object)canceledNote);
        this.tender = tender;
        this.orderHistory = OptionalNullable.of(orderHistory);
        this.promoCode = OptionalNullable.of((Object)promoCode);
        this.btcReceiveAddress = OptionalNullable.of((Object)btcReceiveAddress);
        this.btcPriceSatoshi = OptionalNullable.of((Object)btcPriceSatoshi);
    }

    protected V1Order(OptionalNullable<List<Error>> errors, String id, OptionalNullable<String> buyerEmail, OptionalNullable<String> recipientName, OptionalNullable<String> recipientPhoneNumber, String state, Address shippingAddress, V1Money subtotalMoney, V1Money totalShippingMoney, V1Money totalTaxMoney, V1Money totalPriceMoney, V1Money totalDiscountMoney, String createdAt, String updatedAt, OptionalNullable<String> expiresAt, OptionalNullable<String> paymentId, OptionalNullable<String> buyerNote, OptionalNullable<String> completedNote, OptionalNullable<String> refundedNote, OptionalNullable<String> canceledNote, V1Tender tender, OptionalNullable<List<V1OrderHistoryEntry>> orderHistory, OptionalNullable<String> promoCode, OptionalNullable<String> btcReceiveAddress, OptionalNullable<Double> btcPriceSatoshi) {
        this.errors = errors;
        this.id = id;
        this.buyerEmail = buyerEmail;
        this.recipientName = recipientName;
        this.recipientPhoneNumber = recipientPhoneNumber;
        this.state = state;
        this.shippingAddress = shippingAddress;
        this.subtotalMoney = subtotalMoney;
        this.totalShippingMoney = totalShippingMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalPriceMoney = totalPriceMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.expiresAt = expiresAt;
        this.paymentId = paymentId;
        this.buyerNote = buyerNote;
        this.completedNote = completedNote;
        this.refundedNote = refundedNote;
        this.canceledNote = canceledNote;
        this.tender = tender;
        this.orderHistory = orderHistory;
        this.promoCode = promoCode;
        this.btcReceiveAddress = btcReceiveAddress;
        this.btcPriceSatoshi = btcPriceSatoshi;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Error>> internalGetErrors() {
        return this.errors;
    }

    @JsonIgnore
    public List<Error> getErrors() {
        return (List)OptionalNullable.getFrom(this.errors);
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="buyer_email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBuyerEmail() {
        return this.buyerEmail;
    }

    @JsonIgnore
    public String getBuyerEmail() {
        return (String)OptionalNullable.getFrom(this.buyerEmail);
    }

    @JsonGetter(value="recipient_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRecipientName() {
        return this.recipientName;
    }

    @JsonIgnore
    public String getRecipientName() {
        return (String)OptionalNullable.getFrom(this.recipientName);
    }

    @JsonGetter(value="recipient_phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRecipientPhoneNumber() {
        return this.recipientPhoneNumber;
    }

    @JsonIgnore
    public String getRecipientPhoneNumber() {
        return (String)OptionalNullable.getFrom(this.recipientPhoneNumber);
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonGetter(value="subtotal_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getSubtotalMoney() {
        return this.subtotalMoney;
    }

    @JsonGetter(value="total_shipping_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getTotalShippingMoney() {
        return this.totalShippingMoney;
    }

    @JsonGetter(value="total_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonGetter(value="total_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    @JsonGetter(value="total_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetExpiresAt() {
        return this.expiresAt;
    }

    @JsonIgnore
    public String getExpiresAt() {
        return (String)OptionalNullable.getFrom(this.expiresAt);
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public String getPaymentId() {
        return (String)OptionalNullable.getFrom(this.paymentId);
    }

    @JsonGetter(value="buyer_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBuyerNote() {
        return this.buyerNote;
    }

    @JsonIgnore
    public String getBuyerNote() {
        return (String)OptionalNullable.getFrom(this.buyerNote);
    }

    @JsonGetter(value="completed_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCompletedNote() {
        return this.completedNote;
    }

    @JsonIgnore
    public String getCompletedNote() {
        return (String)OptionalNullable.getFrom(this.completedNote);
    }

    @JsonGetter(value="refunded_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRefundedNote() {
        return this.refundedNote;
    }

    @JsonIgnore
    public String getRefundedNote() {
        return (String)OptionalNullable.getFrom(this.refundedNote);
    }

    @JsonGetter(value="canceled_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCanceledNote() {
        return this.canceledNote;
    }

    @JsonIgnore
    public String getCanceledNote() {
        return (String)OptionalNullable.getFrom(this.canceledNote);
    }

    @JsonGetter(value="tender")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Tender getTender() {
        return this.tender;
    }

    @JsonGetter(value="order_history")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<V1OrderHistoryEntry>> internalGetOrderHistory() {
        return this.orderHistory;
    }

    @JsonIgnore
    public List<V1OrderHistoryEntry> getOrderHistory() {
        return (List)OptionalNullable.getFrom(this.orderHistory);
    }

    @JsonGetter(value="promo_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPromoCode() {
        return this.promoCode;
    }

    @JsonIgnore
    public String getPromoCode() {
        return (String)OptionalNullable.getFrom(this.promoCode);
    }

    @JsonGetter(value="btc_receive_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBtcReceiveAddress() {
        return this.btcReceiveAddress;
    }

    @JsonIgnore
    public String getBtcReceiveAddress() {
        return (String)OptionalNullable.getFrom(this.btcReceiveAddress);
    }

    @JsonGetter(value="btc_price_satoshi")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Double> internalGetBtcPriceSatoshi() {
        return this.btcPriceSatoshi;
    }

    @JsonIgnore
    public Double getBtcPriceSatoshi() {
        return (Double)OptionalNullable.getFrom(this.btcPriceSatoshi);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.id, this.buyerEmail, this.recipientName, this.recipientPhoneNumber, this.state, this.shippingAddress, this.subtotalMoney, this.totalShippingMoney, this.totalTaxMoney, this.totalPriceMoney, this.totalDiscountMoney, this.createdAt, this.updatedAt, this.expiresAt, this.paymentId, this.buyerNote, this.completedNote, this.refundedNote, this.canceledNote, this.tender, this.orderHistory, this.promoCode, this.btcReceiveAddress, this.btcPriceSatoshi);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1Order)) {
            return false;
        }
        V1Order other = (V1Order)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.id, other.id) && Objects.equals(this.buyerEmail, other.buyerEmail) && Objects.equals(this.recipientName, other.recipientName) && Objects.equals(this.recipientPhoneNumber, other.recipientPhoneNumber) && Objects.equals(this.state, other.state) && Objects.equals(this.shippingAddress, other.shippingAddress) && Objects.equals(this.subtotalMoney, other.subtotalMoney) && Objects.equals(this.totalShippingMoney, other.totalShippingMoney) && Objects.equals(this.totalTaxMoney, other.totalTaxMoney) && Objects.equals(this.totalPriceMoney, other.totalPriceMoney) && Objects.equals(this.totalDiscountMoney, other.totalDiscountMoney) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.expiresAt, other.expiresAt) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.buyerNote, other.buyerNote) && Objects.equals(this.completedNote, other.completedNote) && Objects.equals(this.refundedNote, other.refundedNote) && Objects.equals(this.canceledNote, other.canceledNote) && Objects.equals(this.tender, other.tender) && Objects.equals(this.orderHistory, other.orderHistory) && Objects.equals(this.promoCode, other.promoCode) && Objects.equals(this.btcReceiveAddress, other.btcReceiveAddress) && Objects.equals(this.btcPriceSatoshi, other.btcPriceSatoshi);
    }

    public String toString() {
        return "V1Order [errors=" + this.errors + ", id=" + this.id + ", buyerEmail=" + this.buyerEmail + ", recipientName=" + this.recipientName + ", recipientPhoneNumber=" + this.recipientPhoneNumber + ", state=" + this.state + ", shippingAddress=" + this.shippingAddress + ", subtotalMoney=" + this.subtotalMoney + ", totalShippingMoney=" + this.totalShippingMoney + ", totalTaxMoney=" + this.totalTaxMoney + ", totalPriceMoney=" + this.totalPriceMoney + ", totalDiscountMoney=" + this.totalDiscountMoney + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", expiresAt=" + this.expiresAt + ", paymentId=" + this.paymentId + ", buyerNote=" + this.buyerNote + ", completedNote=" + this.completedNote + ", refundedNote=" + this.refundedNote + ", canceledNote=" + this.canceledNote + ", tender=" + this.tender + ", orderHistory=" + this.orderHistory + ", promoCode=" + this.promoCode + ", btcReceiveAddress=" + this.btcReceiveAddress + ", btcPriceSatoshi=" + this.btcPriceSatoshi + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).state(this.getState()).shippingAddress(this.getShippingAddress()).subtotalMoney(this.getSubtotalMoney()).totalShippingMoney(this.getTotalShippingMoney()).totalTaxMoney(this.getTotalTaxMoney()).totalPriceMoney(this.getTotalPriceMoney()).totalDiscountMoney(this.getTotalDiscountMoney()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).tender(this.getTender());
        builder.errors = this.internalGetErrors();
        builder.buyerEmail = this.internalGetBuyerEmail();
        builder.recipientName = this.internalGetRecipientName();
        builder.recipientPhoneNumber = this.internalGetRecipientPhoneNumber();
        builder.expiresAt = this.internalGetExpiresAt();
        builder.paymentId = this.internalGetPaymentId();
        builder.buyerNote = this.internalGetBuyerNote();
        builder.completedNote = this.internalGetCompletedNote();
        builder.refundedNote = this.internalGetRefundedNote();
        builder.canceledNote = this.internalGetCanceledNote();
        builder.orderHistory = this.internalGetOrderHistory();
        builder.promoCode = this.internalGetPromoCode();
        builder.btcReceiveAddress = this.internalGetBtcReceiveAddress();
        builder.btcPriceSatoshi = this.internalGetBtcPriceSatoshi();
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private OptionalNullable<List<Error>> errors;
        private String id;
        private OptionalNullable<String> buyerEmail;
        private OptionalNullable<String> recipientName;
        private OptionalNullable<String> recipientPhoneNumber;
        private String state;
        private Address shippingAddress;
        private V1Money subtotalMoney;
        private V1Money totalShippingMoney;
        private V1Money totalTaxMoney;
        private V1Money totalPriceMoney;
        private V1Money totalDiscountMoney;
        private String createdAt;
        private String updatedAt;
        private OptionalNullable<String> expiresAt;
        private OptionalNullable<String> paymentId;
        private OptionalNullable<String> buyerNote;
        private OptionalNullable<String> completedNote;
        private OptionalNullable<String> refundedNote;
        private OptionalNullable<String> canceledNote;
        private V1Tender tender;
        private OptionalNullable<List<V1OrderHistoryEntry>> orderHistory;
        private OptionalNullable<String> promoCode;
        private OptionalNullable<String> btcReceiveAddress;
        private OptionalNullable<Double> btcPriceSatoshi;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = OptionalNullable.of(errors);
            return this;
        }

        public Builder unsetErrors() {
            this.errors = null;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder buyerEmail(String buyerEmail) {
            this.buyerEmail = OptionalNullable.of((Object)buyerEmail);
            return this;
        }

        public Builder unsetBuyerEmail() {
            this.buyerEmail = null;
            return this;
        }

        public Builder recipientName(String recipientName) {
            this.recipientName = OptionalNullable.of((Object)recipientName);
            return this;
        }

        public Builder unsetRecipientName() {
            this.recipientName = null;
            return this;
        }

        public Builder recipientPhoneNumber(String recipientPhoneNumber) {
            this.recipientPhoneNumber = OptionalNullable.of((Object)recipientPhoneNumber);
            return this;
        }

        public Builder unsetRecipientPhoneNumber() {
            this.recipientPhoneNumber = null;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder subtotalMoney(V1Money subtotalMoney) {
            this.subtotalMoney = subtotalMoney;
            return this;
        }

        public Builder totalShippingMoney(V1Money totalShippingMoney) {
            this.totalShippingMoney = totalShippingMoney;
            return this;
        }

        public Builder totalTaxMoney(V1Money totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder totalPriceMoney(V1Money totalPriceMoney) {
            this.totalPriceMoney = totalPriceMoney;
            return this;
        }

        public Builder totalDiscountMoney(V1Money totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = OptionalNullable.of((Object)expiresAt);
            return this;
        }

        public Builder unsetExpiresAt() {
            this.expiresAt = null;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = OptionalNullable.of((Object)paymentId);
            return this;
        }

        public Builder unsetPaymentId() {
            this.paymentId = null;
            return this;
        }

        public Builder buyerNote(String buyerNote) {
            this.buyerNote = OptionalNullable.of((Object)buyerNote);
            return this;
        }

        public Builder unsetBuyerNote() {
            this.buyerNote = null;
            return this;
        }

        public Builder completedNote(String completedNote) {
            this.completedNote = OptionalNullable.of((Object)completedNote);
            return this;
        }

        public Builder unsetCompletedNote() {
            this.completedNote = null;
            return this;
        }

        public Builder refundedNote(String refundedNote) {
            this.refundedNote = OptionalNullable.of((Object)refundedNote);
            return this;
        }

        public Builder unsetRefundedNote() {
            this.refundedNote = null;
            return this;
        }

        public Builder canceledNote(String canceledNote) {
            this.canceledNote = OptionalNullable.of((Object)canceledNote);
            return this;
        }

        public Builder unsetCanceledNote() {
            this.canceledNote = null;
            return this;
        }

        public Builder tender(V1Tender tender) {
            this.tender = tender;
            return this;
        }

        public Builder orderHistory(List<V1OrderHistoryEntry> orderHistory) {
            this.orderHistory = OptionalNullable.of(orderHistory);
            return this;
        }

        public Builder unsetOrderHistory() {
            this.orderHistory = null;
            return this;
        }

        public Builder promoCode(String promoCode) {
            this.promoCode = OptionalNullable.of((Object)promoCode);
            return this;
        }

        public Builder unsetPromoCode() {
            this.promoCode = null;
            return this;
        }

        public Builder btcReceiveAddress(String btcReceiveAddress) {
            this.btcReceiveAddress = OptionalNullable.of((Object)btcReceiveAddress);
            return this;
        }

        public Builder unsetBtcReceiveAddress() {
            this.btcReceiveAddress = null;
            return this;
        }

        public Builder btcPriceSatoshi(Double btcPriceSatoshi) {
            this.btcPriceSatoshi = OptionalNullable.of((Object)btcPriceSatoshi);
            return this;
        }

        public Builder unsetBtcPriceSatoshi() {
            this.btcPriceSatoshi = null;
            return this;
        }

        public V1Order build() {
            V1Order model = new V1Order(this.errors, this.id, this.buyerEmail, this.recipientName, this.recipientPhoneNumber, this.state, this.shippingAddress, this.subtotalMoney, this.totalShippingMoney, this.totalTaxMoney, this.totalPriceMoney, this.totalDiscountMoney, this.createdAt, this.updatedAt, this.expiresAt, this.paymentId, this.buyerNote, this.completedNote, this.refundedNote, this.canceledNote, this.tender, this.orderHistory, this.promoCode, this.btcReceiveAddress, this.btcPriceSatoshi);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

