/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class V1OrderHistoryEntry {
    private final String action;
    private final String createdAt;

    @JsonCreator
    public V1OrderHistoryEntry(@JsonProperty(value="action") String action, @JsonProperty(value="created_at") String createdAt) {
        this.action = action;
        this.createdAt = createdAt;
    }

    @JsonGetter(value="action")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAction() {
        return this.action;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    public int hashCode() {
        return Objects.hash(this.action, this.createdAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1OrderHistoryEntry)) {
            return false;
        }
        V1OrderHistoryEntry other = (V1OrderHistoryEntry)obj;
        return Objects.equals(this.action, other.action) && Objects.equals(this.createdAt, other.createdAt);
    }

    public String toString() {
        return "V1OrderHistoryEntry [action=" + this.action + ", createdAt=" + this.createdAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().action(this.getAction()).createdAt(this.getCreatedAt());
        return builder;
    }

    public static class Builder {
        private String action;
        private String createdAt;

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public V1OrderHistoryEntry build() {
            return new V1OrderHistoryEntry(this.action, this.createdAt);
        }
    }
}

