/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.V1Device;
import com.squareup.square.models.V1Money;
import com.squareup.square.models.V1PaymentItemization;
import com.squareup.square.models.V1PaymentSurcharge;
import com.squareup.square.models.V1PaymentTax;
import com.squareup.square.models.V1Refund;
import com.squareup.square.models.V1Tender;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class V1Payment {
    private HttpContext httpContext;
    private final String id;
    private final OptionalNullable<String> merchantId;
    private final String createdAt;
    private final OptionalNullable<String> creatorId;
    private final V1Device device;
    private final OptionalNullable<String> paymentUrl;
    private final OptionalNullable<String> receiptUrl;
    private final V1Money inclusiveTaxMoney;
    private final V1Money additiveTaxMoney;
    private final V1Money taxMoney;
    private final V1Money tipMoney;
    private final V1Money discountMoney;
    private final V1Money totalCollectedMoney;
    private final V1Money processingFeeMoney;
    private final V1Money netTotalMoney;
    private final V1Money refundedMoney;
    private final V1Money swedishRoundingMoney;
    private final V1Money grossSalesMoney;
    private final V1Money netSalesMoney;
    private final OptionalNullable<List<V1PaymentTax>> inclusiveTax;
    private final OptionalNullable<List<V1PaymentTax>> additiveTax;
    private final OptionalNullable<List<V1Tender>> tender;
    private final OptionalNullable<List<V1Refund>> refunds;
    private final OptionalNullable<List<V1PaymentItemization>> itemizations;
    private final V1Money surchargeMoney;
    private final OptionalNullable<List<V1PaymentSurcharge>> surcharges;
    private final OptionalNullable<Boolean> isPartial;

    @JsonCreator
    public V1Payment(@JsonProperty(value="id") String id, @JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="creator_id") String creatorId, @JsonProperty(value="device") V1Device device, @JsonProperty(value="payment_url") String paymentUrl, @JsonProperty(value="receipt_url") String receiptUrl, @JsonProperty(value="inclusive_tax_money") V1Money inclusiveTaxMoney, @JsonProperty(value="additive_tax_money") V1Money additiveTaxMoney, @JsonProperty(value="tax_money") V1Money taxMoney, @JsonProperty(value="tip_money") V1Money tipMoney, @JsonProperty(value="discount_money") V1Money discountMoney, @JsonProperty(value="total_collected_money") V1Money totalCollectedMoney, @JsonProperty(value="processing_fee_money") V1Money processingFeeMoney, @JsonProperty(value="net_total_money") V1Money netTotalMoney, @JsonProperty(value="refunded_money") V1Money refundedMoney, @JsonProperty(value="swedish_rounding_money") V1Money swedishRoundingMoney, @JsonProperty(value="gross_sales_money") V1Money grossSalesMoney, @JsonProperty(value="net_sales_money") V1Money netSalesMoney, @JsonProperty(value="inclusive_tax") List<V1PaymentTax> inclusiveTax, @JsonProperty(value="additive_tax") List<V1PaymentTax> additiveTax, @JsonProperty(value="tender") List<V1Tender> tender, @JsonProperty(value="refunds") List<V1Refund> refunds, @JsonProperty(value="itemizations") List<V1PaymentItemization> itemizations, @JsonProperty(value="surcharge_money") V1Money surchargeMoney, @JsonProperty(value="surcharges") List<V1PaymentSurcharge> surcharges, @JsonProperty(value="is_partial") Boolean isPartial) {
        this.id = id;
        this.merchantId = OptionalNullable.of((Object)merchantId);
        this.createdAt = createdAt;
        this.creatorId = OptionalNullable.of((Object)creatorId);
        this.device = device;
        this.paymentUrl = OptionalNullable.of((Object)paymentUrl);
        this.receiptUrl = OptionalNullable.of((Object)receiptUrl);
        this.inclusiveTaxMoney = inclusiveTaxMoney;
        this.additiveTaxMoney = additiveTaxMoney;
        this.taxMoney = taxMoney;
        this.tipMoney = tipMoney;
        this.discountMoney = discountMoney;
        this.totalCollectedMoney = totalCollectedMoney;
        this.processingFeeMoney = processingFeeMoney;
        this.netTotalMoney = netTotalMoney;
        this.refundedMoney = refundedMoney;
        this.swedishRoundingMoney = swedishRoundingMoney;
        this.grossSalesMoney = grossSalesMoney;
        this.netSalesMoney = netSalesMoney;
        this.inclusiveTax = OptionalNullable.of(inclusiveTax);
        this.additiveTax = OptionalNullable.of(additiveTax);
        this.tender = OptionalNullable.of(tender);
        this.refunds = OptionalNullable.of(refunds);
        this.itemizations = OptionalNullable.of(itemizations);
        this.surchargeMoney = surchargeMoney;
        this.surcharges = OptionalNullable.of(surcharges);
        this.isPartial = OptionalNullable.of((Object)isPartial);
    }

    protected V1Payment(String id, OptionalNullable<String> merchantId, String createdAt, OptionalNullable<String> creatorId, V1Device device, OptionalNullable<String> paymentUrl, OptionalNullable<String> receiptUrl, V1Money inclusiveTaxMoney, V1Money additiveTaxMoney, V1Money taxMoney, V1Money tipMoney, V1Money discountMoney, V1Money totalCollectedMoney, V1Money processingFeeMoney, V1Money netTotalMoney, V1Money refundedMoney, V1Money swedishRoundingMoney, V1Money grossSalesMoney, V1Money netSalesMoney, OptionalNullable<List<V1PaymentTax>> inclusiveTax, OptionalNullable<List<V1PaymentTax>> additiveTax, OptionalNullable<List<V1Tender>> tender, OptionalNullable<List<V1Refund>> refunds, OptionalNullable<List<V1PaymentItemization>> itemizations, V1Money surchargeMoney, OptionalNullable<List<V1PaymentSurcharge>> surcharges, OptionalNullable<Boolean> isPartial) {
        this.id = id;
        this.merchantId = merchantId;
        this.createdAt = createdAt;
        this.creatorId = creatorId;
        this.device = device;
        this.paymentUrl = paymentUrl;
        this.receiptUrl = receiptUrl;
        this.inclusiveTaxMoney = inclusiveTaxMoney;
        this.additiveTaxMoney = additiveTaxMoney;
        this.taxMoney = taxMoney;
        this.tipMoney = tipMoney;
        this.discountMoney = discountMoney;
        this.totalCollectedMoney = totalCollectedMoney;
        this.processingFeeMoney = processingFeeMoney;
        this.netTotalMoney = netTotalMoney;
        this.refundedMoney = refundedMoney;
        this.swedishRoundingMoney = swedishRoundingMoney;
        this.grossSalesMoney = grossSalesMoney;
        this.netSalesMoney = netSalesMoney;
        this.inclusiveTax = inclusiveTax;
        this.additiveTax = additiveTax;
        this.tender = tender;
        this.refunds = refunds;
        this.itemizations = itemizations;
        this.surchargeMoney = surchargeMoney;
        this.surcharges = surcharges;
        this.isPartial = isPartial;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMerchantId() {
        return this.merchantId;
    }

    @JsonIgnore
    public String getMerchantId() {
        return (String)OptionalNullable.getFrom(this.merchantId);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="creator_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCreatorId() {
        return this.creatorId;
    }

    @JsonIgnore
    public String getCreatorId() {
        return (String)OptionalNullable.getFrom(this.creatorId);
    }

    @JsonGetter(value="device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Device getDevice() {
        return this.device;
    }

    @JsonGetter(value="payment_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentUrl() {
        return this.paymentUrl;
    }

    @JsonIgnore
    public String getPaymentUrl() {
        return (String)OptionalNullable.getFrom(this.paymentUrl);
    }

    @JsonGetter(value="receipt_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReceiptUrl() {
        return this.receiptUrl;
    }

    @JsonIgnore
    public String getReceiptUrl() {
        return (String)OptionalNullable.getFrom(this.receiptUrl);
    }

    @JsonGetter(value="inclusive_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getInclusiveTaxMoney() {
        return this.inclusiveTaxMoney;
    }

    @JsonGetter(value="additive_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getAdditiveTaxMoney() {
        return this.additiveTaxMoney;
    }

    @JsonGetter(value="tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getTaxMoney() {
        return this.taxMoney;
    }

    @JsonGetter(value="tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getTipMoney() {
        return this.tipMoney;
    }

    @JsonGetter(value="discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getDiscountMoney() {
        return this.discountMoney;
    }

    @JsonGetter(value="total_collected_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getTotalCollectedMoney() {
        return this.totalCollectedMoney;
    }

    @JsonGetter(value="processing_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    @JsonGetter(value="net_total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getNetTotalMoney() {
        return this.netTotalMoney;
    }

    @JsonGetter(value="refunded_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedMoney() {
        return this.refundedMoney;
    }

    @JsonGetter(value="swedish_rounding_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getSwedishRoundingMoney() {
        return this.swedishRoundingMoney;
    }

    @JsonGetter(value="gross_sales_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getGrossSalesMoney() {
        return this.grossSalesMoney;
    }

    @JsonGetter(value="net_sales_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getNetSalesMoney() {
        return this.netSalesMoney;
    }

    @JsonGetter(value="inclusive_tax")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<V1PaymentTax>> internalGetInclusiveTax() {
        return this.inclusiveTax;
    }

    @JsonIgnore
    public List<V1PaymentTax> getInclusiveTax() {
        return (List)OptionalNullable.getFrom(this.inclusiveTax);
    }

    @JsonGetter(value="additive_tax")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<V1PaymentTax>> internalGetAdditiveTax() {
        return this.additiveTax;
    }

    @JsonIgnore
    public List<V1PaymentTax> getAdditiveTax() {
        return (List)OptionalNullable.getFrom(this.additiveTax);
    }

    @JsonGetter(value="tender")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<V1Tender>> internalGetTender() {
        return this.tender;
    }

    @JsonIgnore
    public List<V1Tender> getTender() {
        return (List)OptionalNullable.getFrom(this.tender);
    }

    @JsonGetter(value="refunds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<V1Refund>> internalGetRefunds() {
        return this.refunds;
    }

    @JsonIgnore
    public List<V1Refund> getRefunds() {
        return (List)OptionalNullable.getFrom(this.refunds);
    }

    @JsonGetter(value="itemizations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<V1PaymentItemization>> internalGetItemizations() {
        return this.itemizations;
    }

    @JsonIgnore
    public List<V1PaymentItemization> getItemizations() {
        return (List)OptionalNullable.getFrom(this.itemizations);
    }

    @JsonGetter(value="surcharge_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getSurchargeMoney() {
        return this.surchargeMoney;
    }

    @JsonGetter(value="surcharges")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<V1PaymentSurcharge>> internalGetSurcharges() {
        return this.surcharges;
    }

    @JsonIgnore
    public List<V1PaymentSurcharge> getSurcharges() {
        return (List)OptionalNullable.getFrom(this.surcharges);
    }

    @JsonGetter(value="is_partial")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsPartial() {
        return this.isPartial;
    }

    @JsonIgnore
    public Boolean getIsPartial() {
        return (Boolean)OptionalNullable.getFrom(this.isPartial);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.merchantId, this.createdAt, this.creatorId, this.device, this.paymentUrl, this.receiptUrl, this.inclusiveTaxMoney, this.additiveTaxMoney, this.taxMoney, this.tipMoney, this.discountMoney, this.totalCollectedMoney, this.processingFeeMoney, this.netTotalMoney, this.refundedMoney, this.swedishRoundingMoney, this.grossSalesMoney, this.netSalesMoney, this.inclusiveTax, this.additiveTax, this.tender, this.refunds, this.itemizations, this.surchargeMoney, this.surcharges, this.isPartial);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1Payment)) {
            return false;
        }
        V1Payment other = (V1Payment)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.creatorId, other.creatorId) && Objects.equals(this.device, other.device) && Objects.equals(this.paymentUrl, other.paymentUrl) && Objects.equals(this.receiptUrl, other.receiptUrl) && Objects.equals(this.inclusiveTaxMoney, other.inclusiveTaxMoney) && Objects.equals(this.additiveTaxMoney, other.additiveTaxMoney) && Objects.equals(this.taxMoney, other.taxMoney) && Objects.equals(this.tipMoney, other.tipMoney) && Objects.equals(this.discountMoney, other.discountMoney) && Objects.equals(this.totalCollectedMoney, other.totalCollectedMoney) && Objects.equals(this.processingFeeMoney, other.processingFeeMoney) && Objects.equals(this.netTotalMoney, other.netTotalMoney) && Objects.equals(this.refundedMoney, other.refundedMoney) && Objects.equals(this.swedishRoundingMoney, other.swedishRoundingMoney) && Objects.equals(this.grossSalesMoney, other.grossSalesMoney) && Objects.equals(this.netSalesMoney, other.netSalesMoney) && Objects.equals(this.inclusiveTax, other.inclusiveTax) && Objects.equals(this.additiveTax, other.additiveTax) && Objects.equals(this.tender, other.tender) && Objects.equals(this.refunds, other.refunds) && Objects.equals(this.itemizations, other.itemizations) && Objects.equals(this.surchargeMoney, other.surchargeMoney) && Objects.equals(this.surcharges, other.surcharges) && Objects.equals(this.isPartial, other.isPartial);
    }

    public String toString() {
        return "V1Payment [id=" + this.id + ", merchantId=" + this.merchantId + ", createdAt=" + this.createdAt + ", creatorId=" + this.creatorId + ", device=" + this.device + ", paymentUrl=" + this.paymentUrl + ", receiptUrl=" + this.receiptUrl + ", inclusiveTaxMoney=" + this.inclusiveTaxMoney + ", additiveTaxMoney=" + this.additiveTaxMoney + ", taxMoney=" + this.taxMoney + ", tipMoney=" + this.tipMoney + ", discountMoney=" + this.discountMoney + ", totalCollectedMoney=" + this.totalCollectedMoney + ", processingFeeMoney=" + this.processingFeeMoney + ", netTotalMoney=" + this.netTotalMoney + ", refundedMoney=" + this.refundedMoney + ", swedishRoundingMoney=" + this.swedishRoundingMoney + ", grossSalesMoney=" + this.grossSalesMoney + ", netSalesMoney=" + this.netSalesMoney + ", inclusiveTax=" + this.inclusiveTax + ", additiveTax=" + this.additiveTax + ", tender=" + this.tender + ", refunds=" + this.refunds + ", itemizations=" + this.itemizations + ", surchargeMoney=" + this.surchargeMoney + ", surcharges=" + this.surcharges + ", isPartial=" + this.isPartial + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).createdAt(this.getCreatedAt()).device(this.getDevice()).inclusiveTaxMoney(this.getInclusiveTaxMoney()).additiveTaxMoney(this.getAdditiveTaxMoney()).taxMoney(this.getTaxMoney()).tipMoney(this.getTipMoney()).discountMoney(this.getDiscountMoney()).totalCollectedMoney(this.getTotalCollectedMoney()).processingFeeMoney(this.getProcessingFeeMoney()).netTotalMoney(this.getNetTotalMoney()).refundedMoney(this.getRefundedMoney()).swedishRoundingMoney(this.getSwedishRoundingMoney()).grossSalesMoney(this.getGrossSalesMoney()).netSalesMoney(this.getNetSalesMoney()).surchargeMoney(this.getSurchargeMoney());
        builder.merchantId = this.internalGetMerchantId();
        builder.creatorId = this.internalGetCreatorId();
        builder.paymentUrl = this.internalGetPaymentUrl();
        builder.receiptUrl = this.internalGetReceiptUrl();
        builder.inclusiveTax = this.internalGetInclusiveTax();
        builder.additiveTax = this.internalGetAdditiveTax();
        builder.tender = this.internalGetTender();
        builder.refunds = this.internalGetRefunds();
        builder.itemizations = this.internalGetItemizations();
        builder.surcharges = this.internalGetSurcharges();
        builder.isPartial = this.internalGetIsPartial();
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private String id;
        private OptionalNullable<String> merchantId;
        private String createdAt;
        private OptionalNullable<String> creatorId;
        private V1Device device;
        private OptionalNullable<String> paymentUrl;
        private OptionalNullable<String> receiptUrl;
        private V1Money inclusiveTaxMoney;
        private V1Money additiveTaxMoney;
        private V1Money taxMoney;
        private V1Money tipMoney;
        private V1Money discountMoney;
        private V1Money totalCollectedMoney;
        private V1Money processingFeeMoney;
        private V1Money netTotalMoney;
        private V1Money refundedMoney;
        private V1Money swedishRoundingMoney;
        private V1Money grossSalesMoney;
        private V1Money netSalesMoney;
        private OptionalNullable<List<V1PaymentTax>> inclusiveTax;
        private OptionalNullable<List<V1PaymentTax>> additiveTax;
        private OptionalNullable<List<V1Tender>> tender;
        private OptionalNullable<List<V1Refund>> refunds;
        private OptionalNullable<List<V1PaymentItemization>> itemizations;
        private V1Money surchargeMoney;
        private OptionalNullable<List<V1PaymentSurcharge>> surcharges;
        private OptionalNullable<Boolean> isPartial;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = OptionalNullable.of((Object)merchantId);
            return this;
        }

        public Builder unsetMerchantId() {
            this.merchantId = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder creatorId(String creatorId) {
            this.creatorId = OptionalNullable.of((Object)creatorId);
            return this;
        }

        public Builder unsetCreatorId() {
            this.creatorId = null;
            return this;
        }

        public Builder device(V1Device device) {
            this.device = device;
            return this;
        }

        public Builder paymentUrl(String paymentUrl) {
            this.paymentUrl = OptionalNullable.of((Object)paymentUrl);
            return this;
        }

        public Builder unsetPaymentUrl() {
            this.paymentUrl = null;
            return this;
        }

        public Builder receiptUrl(String receiptUrl) {
            this.receiptUrl = OptionalNullable.of((Object)receiptUrl);
            return this;
        }

        public Builder unsetReceiptUrl() {
            this.receiptUrl = null;
            return this;
        }

        public Builder inclusiveTaxMoney(V1Money inclusiveTaxMoney) {
            this.inclusiveTaxMoney = inclusiveTaxMoney;
            return this;
        }

        public Builder additiveTaxMoney(V1Money additiveTaxMoney) {
            this.additiveTaxMoney = additiveTaxMoney;
            return this;
        }

        public Builder taxMoney(V1Money taxMoney) {
            this.taxMoney = taxMoney;
            return this;
        }

        public Builder tipMoney(V1Money tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        public Builder discountMoney(V1Money discountMoney) {
            this.discountMoney = discountMoney;
            return this;
        }

        public Builder totalCollectedMoney(V1Money totalCollectedMoney) {
            this.totalCollectedMoney = totalCollectedMoney;
            return this;
        }

        public Builder processingFeeMoney(V1Money processingFeeMoney) {
            this.processingFeeMoney = processingFeeMoney;
            return this;
        }

        public Builder netTotalMoney(V1Money netTotalMoney) {
            this.netTotalMoney = netTotalMoney;
            return this;
        }

        public Builder refundedMoney(V1Money refundedMoney) {
            this.refundedMoney = refundedMoney;
            return this;
        }

        public Builder swedishRoundingMoney(V1Money swedishRoundingMoney) {
            this.swedishRoundingMoney = swedishRoundingMoney;
            return this;
        }

        public Builder grossSalesMoney(V1Money grossSalesMoney) {
            this.grossSalesMoney = grossSalesMoney;
            return this;
        }

        public Builder netSalesMoney(V1Money netSalesMoney) {
            this.netSalesMoney = netSalesMoney;
            return this;
        }

        public Builder inclusiveTax(List<V1PaymentTax> inclusiveTax) {
            this.inclusiveTax = OptionalNullable.of(inclusiveTax);
            return this;
        }

        public Builder unsetInclusiveTax() {
            this.inclusiveTax = null;
            return this;
        }

        public Builder additiveTax(List<V1PaymentTax> additiveTax) {
            this.additiveTax = OptionalNullable.of(additiveTax);
            return this;
        }

        public Builder unsetAdditiveTax() {
            this.additiveTax = null;
            return this;
        }

        public Builder tender(List<V1Tender> tender) {
            this.tender = OptionalNullable.of(tender);
            return this;
        }

        public Builder unsetTender() {
            this.tender = null;
            return this;
        }

        public Builder refunds(List<V1Refund> refunds) {
            this.refunds = OptionalNullable.of(refunds);
            return this;
        }

        public Builder unsetRefunds() {
            this.refunds = null;
            return this;
        }

        public Builder itemizations(List<V1PaymentItemization> itemizations) {
            this.itemizations = OptionalNullable.of(itemizations);
            return this;
        }

        public Builder unsetItemizations() {
            this.itemizations = null;
            return this;
        }

        public Builder surchargeMoney(V1Money surchargeMoney) {
            this.surchargeMoney = surchargeMoney;
            return this;
        }

        public Builder surcharges(List<V1PaymentSurcharge> surcharges) {
            this.surcharges = OptionalNullable.of(surcharges);
            return this;
        }

        public Builder unsetSurcharges() {
            this.surcharges = null;
            return this;
        }

        public Builder isPartial(Boolean isPartial) {
            this.isPartial = OptionalNullable.of((Object)isPartial);
            return this;
        }

        public Builder unsetIsPartial() {
            this.isPartial = null;
            return this;
        }

        public V1Payment build() {
            V1Payment model = new V1Payment(this.id, this.merchantId, this.createdAt, this.creatorId, this.device, this.paymentUrl, this.receiptUrl, this.inclusiveTaxMoney, this.additiveTaxMoney, this.taxMoney, this.tipMoney, this.discountMoney, this.totalCollectedMoney, this.processingFeeMoney, this.netTotalMoney, this.refundedMoney, this.swedishRoundingMoney, this.grossSalesMoney, this.netSalesMoney, this.inclusiveTax, this.additiveTax, this.tender, this.refunds, this.itemizations, this.surchargeMoney, this.surcharges, this.isPartial);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

