/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.V1Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class V1PaymentModifier {
    private final OptionalNullable<String> name;
    private final V1Money appliedMoney;
    private final OptionalNullable<String> modifierOptionId;

    @JsonCreator
    public V1PaymentModifier(@JsonProperty(value="name") String name, @JsonProperty(value="applied_money") V1Money appliedMoney, @JsonProperty(value="modifier_option_id") String modifierOptionId) {
        this.name = OptionalNullable.of((Object)name);
        this.appliedMoney = appliedMoney;
        this.modifierOptionId = OptionalNullable.of((Object)modifierOptionId);
    }

    protected V1PaymentModifier(OptionalNullable<String> name, V1Money appliedMoney, OptionalNullable<String> modifierOptionId) {
        this.name = name;
        this.appliedMoney = appliedMoney;
        this.modifierOptionId = modifierOptionId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="modifier_option_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetModifierOptionId() {
        return this.modifierOptionId;
    }

    @JsonIgnore
    public String getModifierOptionId() {
        return (String)OptionalNullable.getFrom(this.modifierOptionId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.appliedMoney, this.modifierOptionId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1PaymentModifier)) {
            return false;
        }
        V1PaymentModifier other = (V1PaymentModifier)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.modifierOptionId, other.modifierOptionId);
    }

    public String toString() {
        return "V1PaymentModifier [name=" + this.name + ", appliedMoney=" + this.appliedMoney + ", modifierOptionId=" + this.modifierOptionId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().appliedMoney(this.getAppliedMoney());
        builder.name = this.internalGetName();
        builder.modifierOptionId = this.internalGetModifierOptionId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private V1Money appliedMoney;
        private OptionalNullable<String> modifierOptionId;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder appliedMoney(V1Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder modifierOptionId(String modifierOptionId) {
            this.modifierOptionId = OptionalNullable.of((Object)modifierOptionId);
            return this;
        }

        public Builder unsetModifierOptionId() {
            this.modifierOptionId = null;
            return this;
        }

        public V1PaymentModifier build() {
            return new V1PaymentModifier(this.name, this.appliedMoney, this.modifierOptionId);
        }
    }
}

