/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Error;
import com.squareup.square.models.V1Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class V1PaymentTax {
    private final OptionalNullable<List<Error>> errors;
    private final OptionalNullable<String> name;
    private final V1Money appliedMoney;
    private final OptionalNullable<String> rate;
    private final String inclusionType;
    private final OptionalNullable<String> feeId;

    @JsonCreator
    public V1PaymentTax(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="name") String name, @JsonProperty(value="applied_money") V1Money appliedMoney, @JsonProperty(value="rate") String rate, @JsonProperty(value="inclusion_type") String inclusionType, @JsonProperty(value="fee_id") String feeId) {
        this.errors = OptionalNullable.of(errors);
        this.name = OptionalNullable.of((Object)name);
        this.appliedMoney = appliedMoney;
        this.rate = OptionalNullable.of((Object)rate);
        this.inclusionType = inclusionType;
        this.feeId = OptionalNullable.of((Object)feeId);
    }

    protected V1PaymentTax(OptionalNullable<List<Error>> errors, OptionalNullable<String> name, V1Money appliedMoney, OptionalNullable<String> rate, String inclusionType, OptionalNullable<String> feeId) {
        this.errors = errors;
        this.name = name;
        this.appliedMoney = appliedMoney;
        this.rate = rate;
        this.inclusionType = inclusionType;
        this.feeId = feeId;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Error>> internalGetErrors() {
        return this.errors;
    }

    @JsonIgnore
    public List<Error> getErrors() {
        return (List)OptionalNullable.getFrom(this.errors);
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRate() {
        return this.rate;
    }

    @JsonIgnore
    public String getRate() {
        return (String)OptionalNullable.getFrom(this.rate);
    }

    @JsonGetter(value="inclusion_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInclusionType() {
        return this.inclusionType;
    }

    @JsonGetter(value="fee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFeeId() {
        return this.feeId;
    }

    @JsonIgnore
    public String getFeeId() {
        return (String)OptionalNullable.getFrom(this.feeId);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.name, this.appliedMoney, this.rate, this.inclusionType, this.feeId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1PaymentTax)) {
            return false;
        }
        V1PaymentTax other = (V1PaymentTax)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.name, other.name) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.rate, other.rate) && Objects.equals(this.inclusionType, other.inclusionType) && Objects.equals(this.feeId, other.feeId);
    }

    public String toString() {
        return "V1PaymentTax [errors=" + this.errors + ", name=" + this.name + ", appliedMoney=" + this.appliedMoney + ", rate=" + this.rate + ", inclusionType=" + this.inclusionType + ", feeId=" + this.feeId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().appliedMoney(this.getAppliedMoney()).inclusionType(this.getInclusionType());
        builder.errors = this.internalGetErrors();
        builder.name = this.internalGetName();
        builder.rate = this.internalGetRate();
        builder.feeId = this.internalGetFeeId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<Error>> errors;
        private OptionalNullable<String> name;
        private V1Money appliedMoney;
        private OptionalNullable<String> rate;
        private String inclusionType;
        private OptionalNullable<String> feeId;

        public Builder errors(List<Error> errors) {
            this.errors = OptionalNullable.of(errors);
            return this;
        }

        public Builder unsetErrors() {
            this.errors = null;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder appliedMoney(V1Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder rate(String rate) {
            this.rate = OptionalNullable.of((Object)rate);
            return this;
        }

        public Builder unsetRate() {
            this.rate = null;
            return this;
        }

        public Builder inclusionType(String inclusionType) {
            this.inclusionType = inclusionType;
            return this;
        }

        public Builder feeId(String feeId) {
            this.feeId = OptionalNullable.of((Object)feeId);
            return this;
        }

        public Builder unsetFeeId() {
            this.feeId = null;
            return this;
        }

        public V1PaymentTax build() {
            return new V1PaymentTax(this.errors, this.name, this.appliedMoney, this.rate, this.inclusionType, this.feeId);
        }
    }
}

