/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class V1PhoneNumber {
    private final String callingCode;
    private final String number;

    @JsonCreator
    public V1PhoneNumber(@JsonProperty(value="calling_code") String callingCode, @JsonProperty(value="number") String number) {
        this.callingCode = callingCode;
        this.number = number;
    }

    @JsonGetter(value="calling_code")
    public String getCallingCode() {
        return this.callingCode;
    }

    @JsonGetter(value="number")
    public String getNumber() {
        return this.number;
    }

    public int hashCode() {
        return Objects.hash(this.callingCode, this.number);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1PhoneNumber)) {
            return false;
        }
        V1PhoneNumber other = (V1PhoneNumber)obj;
        return Objects.equals(this.callingCode, other.callingCode) && Objects.equals(this.number, other.number);
    }

    public String toString() {
        return "V1PhoneNumber [callingCode=" + this.callingCode + ", number=" + this.number + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.callingCode, this.number);
        return builder;
    }

    public static class Builder {
        private String callingCode;
        private String number;

        public Builder(String callingCode, String number) {
            this.callingCode = callingCode;
            this.number = number;
        }

        public Builder callingCode(String callingCode) {
            this.callingCode = callingCode;
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public V1PhoneNumber build() {
            return new V1PhoneNumber(this.callingCode, this.number);
        }
    }
}

