/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class WebhookSubscription {
    private final String id;
    private final OptionalNullable<String> name;
    private final OptionalNullable<Boolean> enabled;
    private final OptionalNullable<List<String>> eventTypes;
    private final OptionalNullable<String> notificationUrl;
    private final OptionalNullable<String> apiVersion;
    private final String signatureKey;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public WebhookSubscription(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="event_types") List<String> eventTypes, @JsonProperty(value="notification_url") String notificationUrl, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="signature_key") String signatureKey, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.name = OptionalNullable.of((Object)name);
        this.enabled = OptionalNullable.of((Object)enabled);
        this.eventTypes = OptionalNullable.of(eventTypes);
        this.notificationUrl = OptionalNullable.of((Object)notificationUrl);
        this.apiVersion = OptionalNullable.of((Object)apiVersion);
        this.signatureKey = signatureKey;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    protected WebhookSubscription(String id, OptionalNullable<String> name, OptionalNullable<Boolean> enabled, OptionalNullable<List<String>> eventTypes, OptionalNullable<String> notificationUrl, OptionalNullable<String> apiVersion, String signatureKey, String createdAt, String updatedAt) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
        this.eventTypes = eventTypes;
        this.notificationUrl = notificationUrl;
        this.apiVersion = apiVersion;
        this.signatureKey = signatureKey;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetEnabled() {
        return this.enabled;
    }

    @JsonIgnore
    public Boolean getEnabled() {
        return (Boolean)OptionalNullable.getFrom(this.enabled);
    }

    @JsonGetter(value="event_types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetEventTypes() {
        return this.eventTypes;
    }

    @JsonIgnore
    public List<String> getEventTypes() {
        return (List)OptionalNullable.getFrom(this.eventTypes);
    }

    @JsonGetter(value="notification_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNotificationUrl() {
        return this.notificationUrl;
    }

    @JsonIgnore
    public String getNotificationUrl() {
        return (String)OptionalNullable.getFrom(this.notificationUrl);
    }

    @JsonGetter(value="api_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetApiVersion() {
        return this.apiVersion;
    }

    @JsonIgnore
    public String getApiVersion() {
        return (String)OptionalNullable.getFrom(this.apiVersion);
    }

    @JsonGetter(value="signature_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSignatureKey() {
        return this.signatureKey;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.enabled, this.eventTypes, this.notificationUrl, this.apiVersion, this.signatureKey, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WebhookSubscription)) {
            return false;
        }
        WebhookSubscription other = (WebhookSubscription)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.eventTypes, other.eventTypes) && Objects.equals(this.notificationUrl, other.notificationUrl) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.signatureKey, other.signatureKey) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "WebhookSubscription [id=" + this.id + ", name=" + this.name + ", enabled=" + this.enabled + ", eventTypes=" + this.eventTypes + ", notificationUrl=" + this.notificationUrl + ", apiVersion=" + this.apiVersion + ", signatureKey=" + this.signatureKey + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).signatureKey(this.getSignatureKey()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        builder.name = this.internalGetName();
        builder.enabled = this.internalGetEnabled();
        builder.eventTypes = this.internalGetEventTypes();
        builder.notificationUrl = this.internalGetNotificationUrl();
        builder.apiVersion = this.internalGetApiVersion();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<String> name;
        private OptionalNullable<Boolean> enabled;
        private OptionalNullable<List<String>> eventTypes;
        private OptionalNullable<String> notificationUrl;
        private OptionalNullable<String> apiVersion;
        private String signatureKey;
        private String createdAt;
        private String updatedAt;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = OptionalNullable.of((Object)enabled);
            return this;
        }

        public Builder unsetEnabled() {
            this.enabled = null;
            return this;
        }

        public Builder eventTypes(List<String> eventTypes) {
            this.eventTypes = OptionalNullable.of(eventTypes);
            return this;
        }

        public Builder unsetEventTypes() {
            this.eventTypes = null;
            return this;
        }

        public Builder notificationUrl(String notificationUrl) {
            this.notificationUrl = OptionalNullable.of((Object)notificationUrl);
            return this;
        }

        public Builder unsetNotificationUrl() {
            this.notificationUrl = null;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = OptionalNullable.of((Object)apiVersion);
            return this;
        }

        public Builder unsetApiVersion() {
            this.apiVersion = null;
            return this;
        }

        public Builder signatureKey(String signatureKey) {
            this.signatureKey = signatureKey;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public WebhookSubscription build() {
            return new WebhookSubscription(this.id, this.name, this.enabled, this.eventTypes, this.notificationUrl, this.apiVersion, this.signatureKey, this.createdAt, this.updatedAt);
        }
    }
}

