/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class WorkweekConfig {
    private final String id;
    private final String startOfWeek;
    private final String startOfDayLocalTime;
    private final Integer version;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public WorkweekConfig(@JsonProperty(value="start_of_week") String startOfWeek, @JsonProperty(value="start_of_day_local_time") String startOfDayLocalTime, @JsonProperty(value="id") String id, @JsonProperty(value="version") Integer version, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.startOfWeek = startOfWeek;
        this.startOfDayLocalTime = startOfDayLocalTime;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="start_of_week")
    public String getStartOfWeek() {
        return this.startOfWeek;
    }

    @JsonGetter(value="start_of_day_local_time")
    public String getStartOfDayLocalTime() {
        return this.startOfDayLocalTime;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.startOfWeek, this.startOfDayLocalTime, this.version, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkweekConfig)) {
            return false;
        }
        WorkweekConfig other = (WorkweekConfig)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.startOfWeek, other.startOfWeek) && Objects.equals(this.startOfDayLocalTime, other.startOfDayLocalTime) && Objects.equals(this.version, other.version) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "WorkweekConfig [startOfWeek=" + this.startOfWeek + ", startOfDayLocalTime=" + this.startOfDayLocalTime + ", id=" + this.id + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.startOfWeek, this.startOfDayLocalTime).id(this.getId()).version(this.getVersion()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        return builder;
    }

    public static class Builder {
        private String startOfWeek;
        private String startOfDayLocalTime;
        private String id;
        private Integer version;
        private String createdAt;
        private String updatedAt;

        public Builder(String startOfWeek, String startOfDayLocalTime) {
            this.startOfWeek = startOfWeek;
            this.startOfDayLocalTime = startOfDayLocalTime;
        }

        public Builder startOfWeek(String startOfWeek) {
            this.startOfWeek = startOfWeek;
            return this;
        }

        public Builder startOfDayLocalTime(String startOfDayLocalTime) {
            this.startOfDayLocalTime = startOfDayLocalTime;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public WorkweekConfig build() {
            return new WorkweekConfig(this.startOfWeek, this.startOfDayLocalTime, this.id, this.version, this.createdAt, this.updatedAt);
        }
    }
}

