/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawCatalogClient;
import com.squareup.square.catalog.AsyncImagesClient;
import com.squareup.square.catalog.AsyncObjectClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BatchDeleteCatalogObjectsRequest;
import com.squareup.square.types.BatchDeleteCatalogObjectsResponse;
import com.squareup.square.types.BatchGetCatalogObjectsRequest;
import com.squareup.square.types.BatchGetCatalogObjectsResponse;
import com.squareup.square.types.BatchUpsertCatalogObjectsRequest;
import com.squareup.square.types.BatchUpsertCatalogObjectsResponse;
import com.squareup.square.types.CatalogInfoResponse;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.ListCatalogRequest;
import com.squareup.square.types.SearchCatalogItemsRequest;
import com.squareup.square.types.SearchCatalogItemsResponse;
import com.squareup.square.types.SearchCatalogObjectsRequest;
import com.squareup.square.types.SearchCatalogObjectsResponse;
import com.squareup.square.types.UpdateItemModifierListsRequest;
import com.squareup.square.types.UpdateItemModifierListsResponse;
import com.squareup.square.types.UpdateItemTaxesRequest;
import com.squareup.square.types.UpdateItemTaxesResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncCatalogClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCatalogClient rawClient;
    protected final Supplier<AsyncImagesClient> imagesClient;
    protected final Supplier<AsyncObjectClient> objectClient;

    public AsyncCatalogClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCatalogClient(clientOptions);
        this.imagesClient = Suppliers.memoize(() -> new AsyncImagesClient(clientOptions));
        this.objectClient = Suppliers.memoize(() -> new AsyncObjectClient(clientOptions));
    }

    public AsyncRawCatalogClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<BatchDeleteCatalogObjectsResponse> batchDelete(BatchDeleteCatalogObjectsRequest request) {
        return this.rawClient.batchDelete(request).thenApply(response -> (BatchDeleteCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<BatchDeleteCatalogObjectsResponse> batchDelete(BatchDeleteCatalogObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchDelete(request, requestOptions).thenApply(response -> (BatchDeleteCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<BatchGetCatalogObjectsResponse> batchGet(BatchGetCatalogObjectsRequest request) {
        return this.rawClient.batchGet(request).thenApply(response -> (BatchGetCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<BatchGetCatalogObjectsResponse> batchGet(BatchGetCatalogObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchGet(request, requestOptions).thenApply(response -> (BatchGetCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<BatchUpsertCatalogObjectsResponse> batchUpsert(BatchUpsertCatalogObjectsRequest request) {
        return this.rawClient.batchUpsert(request).thenApply(response -> (BatchUpsertCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<BatchUpsertCatalogObjectsResponse> batchUpsert(BatchUpsertCatalogObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchUpsert(request, requestOptions).thenApply(response -> (BatchUpsertCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<CatalogInfoResponse> info() {
        return this.rawClient.info().thenApply(response -> (CatalogInfoResponse)response.body());
    }

    public CompletableFuture<CatalogInfoResponse> info(RequestOptions requestOptions) {
        return this.rawClient.info(requestOptions).thenApply(response -> (CatalogInfoResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CatalogObject>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CatalogObject>> list(ListCatalogRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CatalogObject>> list(ListCatalogRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SearchCatalogObjectsResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<SearchCatalogObjectsResponse> search(SearchCatalogObjectsRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<SearchCatalogObjectsResponse> search(SearchCatalogObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchCatalogObjectsResponse)response.body());
    }

    public CompletableFuture<SearchCatalogItemsResponse> searchItems() {
        return this.rawClient.searchItems().thenApply(response -> (SearchCatalogItemsResponse)response.body());
    }

    public CompletableFuture<SearchCatalogItemsResponse> searchItems(SearchCatalogItemsRequest request) {
        return this.rawClient.searchItems(request).thenApply(response -> (SearchCatalogItemsResponse)response.body());
    }

    public CompletableFuture<SearchCatalogItemsResponse> searchItems(SearchCatalogItemsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchItems(request, requestOptions).thenApply(response -> (SearchCatalogItemsResponse)response.body());
    }

    public CompletableFuture<UpdateItemModifierListsResponse> updateItemModifierLists(UpdateItemModifierListsRequest request) {
        return this.rawClient.updateItemModifierLists(request).thenApply(response -> (UpdateItemModifierListsResponse)response.body());
    }

    public CompletableFuture<UpdateItemModifierListsResponse> updateItemModifierLists(UpdateItemModifierListsRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateItemModifierLists(request, requestOptions).thenApply(response -> (UpdateItemModifierListsResponse)response.body());
    }

    public CompletableFuture<UpdateItemTaxesResponse> updateItemTaxes(UpdateItemTaxesRequest request) {
        return this.rawClient.updateItemTaxes(request).thenApply(response -> (UpdateItemTaxesResponse)response.body());
    }

    public CompletableFuture<UpdateItemTaxesResponse> updateItemTaxes(UpdateItemTaxesRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateItemTaxes(request, requestOptions).thenApply(response -> (UpdateItemTaxesResponse)response.body());
    }

    public AsyncImagesClient images() {
        return this.imagesClient.get();
    }

    public AsyncObjectClient object() {
        return this.objectClient.get();
    }
}

