/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawEventsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.DisableEventsResponse;
import com.squareup.square.types.EnableEventsResponse;
import com.squareup.square.types.ListEventTypesRequest;
import com.squareup.square.types.ListEventTypesResponse;
import com.squareup.square.types.SearchEventsRequest;
import com.squareup.square.types.SearchEventsResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncEventsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawEventsClient rawClient;

    public AsyncEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEventsClient(clientOptions);
    }

    public AsyncRawEventsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SearchEventsResponse> searchEvents() {
        return this.rawClient.searchEvents().thenApply(response -> (SearchEventsResponse)response.body());
    }

    public CompletableFuture<SearchEventsResponse> searchEvents(SearchEventsRequest request) {
        return this.rawClient.searchEvents(request).thenApply(response -> (SearchEventsResponse)response.body());
    }

    public CompletableFuture<SearchEventsResponse> searchEvents(SearchEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchEvents(request, requestOptions).thenApply(response -> (SearchEventsResponse)response.body());
    }

    public CompletableFuture<DisableEventsResponse> disableEvents() {
        return this.rawClient.disableEvents().thenApply(response -> (DisableEventsResponse)response.body());
    }

    public CompletableFuture<DisableEventsResponse> disableEvents(RequestOptions requestOptions) {
        return this.rawClient.disableEvents(requestOptions).thenApply(response -> (DisableEventsResponse)response.body());
    }

    public CompletableFuture<EnableEventsResponse> enableEvents() {
        return this.rawClient.enableEvents().thenApply(response -> (EnableEventsResponse)response.body());
    }

    public CompletableFuture<EnableEventsResponse> enableEvents(RequestOptions requestOptions) {
        return this.rawClient.enableEvents(requestOptions).thenApply(response -> (EnableEventsResponse)response.body());
    }

    public CompletableFuture<ListEventTypesResponse> listEventTypes() {
        return this.rawClient.listEventTypes().thenApply(response -> (ListEventTypesResponse)response.body());
    }

    public CompletableFuture<ListEventTypesResponse> listEventTypes(ListEventTypesRequest request) {
        return this.rawClient.listEventTypes(request).thenApply(response -> (ListEventTypesResponse)response.body());
    }

    public CompletableFuture<ListEventTypesResponse> listEventTypes(ListEventTypesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEventTypes(request, requestOptions).thenApply(response -> (ListEventTypesResponse)response.body());
    }
}

