/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawLocationsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.locations.AsyncCustomAttributeDefinitionsClient;
import com.squareup.square.locations.AsyncCustomAttributesClient;
import com.squareup.square.locations.AsyncTransactionsClient;
import com.squareup.square.types.CreateCheckoutRequest;
import com.squareup.square.types.CreateCheckoutResponse;
import com.squareup.square.types.CreateLocationRequest;
import com.squareup.square.types.CreateLocationResponse;
import com.squareup.square.types.GetLocationResponse;
import com.squareup.square.types.GetLocationsRequest;
import com.squareup.square.types.ListLocationsResponse;
import com.squareup.square.types.UpdateLocationRequest;
import com.squareup.square.types.UpdateLocationResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncLocationsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawLocationsClient rawClient;
    protected final Supplier<AsyncCustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<AsyncCustomAttributesClient> customAttributesClient;
    protected final Supplier<AsyncTransactionsClient> transactionsClient;

    public AsyncLocationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawLocationsClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new AsyncCustomAttributeDefinitionsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new AsyncCustomAttributesClient(clientOptions));
        this.transactionsClient = Suppliers.memoize(() -> new AsyncTransactionsClient(clientOptions));
    }

    public AsyncRawLocationsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListLocationsResponse> list() {
        return this.rawClient.list().thenApply(response -> (ListLocationsResponse)response.body());
    }

    public CompletableFuture<ListLocationsResponse> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (ListLocationsResponse)response.body());
    }

    public CompletableFuture<CreateLocationResponse> create() {
        return this.rawClient.create().thenApply(response -> (CreateLocationResponse)response.body());
    }

    public CompletableFuture<CreateLocationResponse> create(CreateLocationRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateLocationResponse)response.body());
    }

    public CompletableFuture<CreateLocationResponse> create(CreateLocationRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateLocationResponse)response.body());
    }

    public CompletableFuture<GetLocationResponse> get(GetLocationsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetLocationResponse)response.body());
    }

    public CompletableFuture<GetLocationResponse> get(GetLocationsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetLocationResponse)response.body());
    }

    public CompletableFuture<UpdateLocationResponse> update(UpdateLocationRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateLocationResponse)response.body());
    }

    public CompletableFuture<UpdateLocationResponse> update(UpdateLocationRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateLocationResponse)response.body());
    }

    public CompletableFuture<CreateCheckoutResponse> checkouts(CreateCheckoutRequest request) {
        return this.rawClient.checkouts(request).thenApply(response -> (CreateCheckoutResponse)response.body());
    }

    public CompletableFuture<CreateCheckoutResponse> checkouts(CreateCheckoutRequest request, RequestOptions requestOptions) {
        return this.rawClient.checkouts(request, requestOptions).thenApply(response -> (CreateCheckoutResponse)response.body());
    }

    public AsyncCustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public AsyncCustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }

    public AsyncTransactionsClient transactions() {
        return this.transactionsClient.get();
    }
}

