/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawOAuthClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.ObtainTokenRequest;
import com.squareup.square.types.ObtainTokenResponse;
import com.squareup.square.types.RetrieveTokenStatusResponse;
import com.squareup.square.types.RevokeTokenRequest;
import com.squareup.square.types.RevokeTokenResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncOAuthClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawOAuthClient rawClient;

    public AsyncOAuthClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOAuthClient(clientOptions);
    }

    public AsyncRawOAuthClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<RevokeTokenResponse> revokeToken() {
        return this.rawClient.revokeToken().thenApply(response -> (RevokeTokenResponse)response.body());
    }

    public CompletableFuture<RevokeTokenResponse> revokeToken(RevokeTokenRequest request) {
        return this.rawClient.revokeToken(request).thenApply(response -> (RevokeTokenResponse)response.body());
    }

    public CompletableFuture<RevokeTokenResponse> revokeToken(RevokeTokenRequest request, RequestOptions requestOptions) {
        return this.rawClient.revokeToken(request, requestOptions).thenApply(response -> (RevokeTokenResponse)response.body());
    }

    public CompletableFuture<ObtainTokenResponse> obtainToken(ObtainTokenRequest request) {
        return this.rawClient.obtainToken(request).thenApply(response -> (ObtainTokenResponse)response.body());
    }

    public CompletableFuture<ObtainTokenResponse> obtainToken(ObtainTokenRequest request, RequestOptions requestOptions) {
        return this.rawClient.obtainToken(request, requestOptions).thenApply(response -> (ObtainTokenResponse)response.body());
    }

    public CompletableFuture<RetrieveTokenStatusResponse> retrieveTokenStatus() {
        return this.rawClient.retrieveTokenStatus().thenApply(response -> (RetrieveTokenStatusResponse)response.body());
    }

    public CompletableFuture<RetrieveTokenStatusResponse> retrieveTokenStatus(RequestOptions requestOptions) {
        return this.rawClient.retrieveTokenStatus(requestOptions).thenApply(response -> (RetrieveTokenStatusResponse)response.body());
    }

    public CompletableFuture<Void> authorize() {
        return this.rawClient.authorize().thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> authorize(RequestOptions requestOptions) {
        return this.rawClient.authorize(requestOptions).thenApply(response -> (Void)response.body());
    }
}

