/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawOrdersClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.orders.AsyncCustomAttributeDefinitionsClient;
import com.squareup.square.orders.AsyncCustomAttributesClient;
import com.squareup.square.types.BatchGetOrdersRequest;
import com.squareup.square.types.BatchGetOrdersResponse;
import com.squareup.square.types.CalculateOrderRequest;
import com.squareup.square.types.CalculateOrderResponse;
import com.squareup.square.types.CloneOrderRequest;
import com.squareup.square.types.CloneOrderResponse;
import com.squareup.square.types.CreateOrderRequest;
import com.squareup.square.types.CreateOrderResponse;
import com.squareup.square.types.GetOrderResponse;
import com.squareup.square.types.GetOrdersRequest;
import com.squareup.square.types.PayOrderRequest;
import com.squareup.square.types.PayOrderResponse;
import com.squareup.square.types.SearchOrdersRequest;
import com.squareup.square.types.SearchOrdersResponse;
import com.squareup.square.types.UpdateOrderRequest;
import com.squareup.square.types.UpdateOrderResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncOrdersClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawOrdersClient rawClient;
    protected final Supplier<AsyncCustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<AsyncCustomAttributesClient> customAttributesClient;

    public AsyncOrdersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrdersClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new AsyncCustomAttributeDefinitionsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new AsyncCustomAttributesClient(clientOptions));
    }

    public AsyncRawOrdersClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateOrderResponse> create() {
        return this.rawClient.create().thenApply(response -> (CreateOrderResponse)response.body());
    }

    public CompletableFuture<CreateOrderResponse> create(CreateOrderRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateOrderResponse)response.body());
    }

    public CompletableFuture<CreateOrderResponse> create(CreateOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateOrderResponse)response.body());
    }

    public CompletableFuture<BatchGetOrdersResponse> batchGet(BatchGetOrdersRequest request) {
        return this.rawClient.batchGet(request).thenApply(response -> (BatchGetOrdersResponse)response.body());
    }

    public CompletableFuture<BatchGetOrdersResponse> batchGet(BatchGetOrdersRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchGet(request, requestOptions).thenApply(response -> (BatchGetOrdersResponse)response.body());
    }

    public CompletableFuture<CalculateOrderResponse> calculate(CalculateOrderRequest request) {
        return this.rawClient.calculate(request).thenApply(response -> (CalculateOrderResponse)response.body());
    }

    public CompletableFuture<CalculateOrderResponse> calculate(CalculateOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.calculate(request, requestOptions).thenApply(response -> (CalculateOrderResponse)response.body());
    }

    public CompletableFuture<CloneOrderResponse> clone(CloneOrderRequest request) {
        return this.rawClient.clone(request).thenApply(response -> (CloneOrderResponse)response.body());
    }

    public CompletableFuture<CloneOrderResponse> clone(CloneOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.clone(request, requestOptions).thenApply(response -> (CloneOrderResponse)response.body());
    }

    public CompletableFuture<SearchOrdersResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchOrdersResponse)response.body());
    }

    public CompletableFuture<SearchOrdersResponse> search(SearchOrdersRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchOrdersResponse)response.body());
    }

    public CompletableFuture<SearchOrdersResponse> search(SearchOrdersRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchOrdersResponse)response.body());
    }

    public CompletableFuture<GetOrderResponse> get(GetOrdersRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetOrderResponse)response.body());
    }

    public CompletableFuture<GetOrderResponse> get(GetOrdersRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetOrderResponse)response.body());
    }

    public CompletableFuture<UpdateOrderResponse> update(UpdateOrderRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateOrderResponse)response.body());
    }

    public CompletableFuture<UpdateOrderResponse> update(UpdateOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateOrderResponse)response.body());
    }

    public CompletableFuture<PayOrderResponse> pay(PayOrderRequest request) {
        return this.rawClient.pay(request).thenApply(response -> (PayOrderResponse)response.body());
    }

    public CompletableFuture<PayOrderResponse> pay(PayOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.pay(request, requestOptions).thenApply(response -> (PayOrderResponse)response.body());
    }

    public AsyncCustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public AsyncCustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }
}

