/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncSquareClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.Environment;
import okhttp3.OkHttpClient;

public final class AsyncSquareClientBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String token = System.getenv("SQUARE_TOKEN");
    private String version = "2025-06-18";
    private Environment environment = Environment.PRODUCTION;

    public AsyncSquareClientBuilder token(String token) {
        this.token = token;
        return this;
    }

    public AsyncSquareClientBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AsyncSquareClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public AsyncSquareClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public AsyncSquareClientBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public AsyncSquareClientBuilder maxRetries(int maxRetries) {
        this.clientOptionsBuilder.maxRetries(maxRetries);
        return this;
    }

    public AsyncSquareClientBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public AsyncSquareClient build() {
        this.clientOptionsBuilder.addHeader("Authorization", "Bearer " + this.token);
        this.clientOptionsBuilder.addHeader("Square-Version", this.version);
        this.clientOptionsBuilder.environment(this.environment);
        return new AsyncSquareClient(this.clientOptionsBuilder.build());
    }
}

