/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawTerminalClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.terminal.AsyncActionsClient;
import com.squareup.square.terminal.AsyncCheckoutsClient;
import com.squareup.square.terminal.AsyncRefundsClient;
import com.squareup.square.types.DismissTerminalActionRequest;
import com.squareup.square.types.DismissTerminalActionResponse;
import com.squareup.square.types.DismissTerminalCheckoutRequest;
import com.squareup.square.types.DismissTerminalCheckoutResponse;
import com.squareup.square.types.DismissTerminalRefundRequest;
import com.squareup.square.types.DismissTerminalRefundResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTerminalClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTerminalClient rawClient;
    protected final Supplier<AsyncActionsClient> actionsClient;
    protected final Supplier<AsyncCheckoutsClient> checkoutsClient;
    protected final Supplier<AsyncRefundsClient> refundsClient;

    public AsyncTerminalClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTerminalClient(clientOptions);
        this.actionsClient = Suppliers.memoize(() -> new AsyncActionsClient(clientOptions));
        this.checkoutsClient = Suppliers.memoize(() -> new AsyncCheckoutsClient(clientOptions));
        this.refundsClient = Suppliers.memoize(() -> new AsyncRefundsClient(clientOptions));
    }

    public AsyncRawTerminalClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DismissTerminalActionResponse> dismissTerminalAction(DismissTerminalActionRequest request) {
        return this.rawClient.dismissTerminalAction(request).thenApply(response -> (DismissTerminalActionResponse)response.body());
    }

    public CompletableFuture<DismissTerminalActionResponse> dismissTerminalAction(DismissTerminalActionRequest request, RequestOptions requestOptions) {
        return this.rawClient.dismissTerminalAction(request, requestOptions).thenApply(response -> (DismissTerminalActionResponse)response.body());
    }

    public CompletableFuture<DismissTerminalCheckoutResponse> dismissTerminalCheckout(DismissTerminalCheckoutRequest request) {
        return this.rawClient.dismissTerminalCheckout(request).thenApply(response -> (DismissTerminalCheckoutResponse)response.body());
    }

    public CompletableFuture<DismissTerminalCheckoutResponse> dismissTerminalCheckout(DismissTerminalCheckoutRequest request, RequestOptions requestOptions) {
        return this.rawClient.dismissTerminalCheckout(request, requestOptions).thenApply(response -> (DismissTerminalCheckoutResponse)response.body());
    }

    public CompletableFuture<DismissTerminalRefundResponse> dismissTerminalRefund(DismissTerminalRefundRequest request) {
        return this.rawClient.dismissTerminalRefund(request).thenApply(response -> (DismissTerminalRefundResponse)response.body());
    }

    public CompletableFuture<DismissTerminalRefundResponse> dismissTerminalRefund(DismissTerminalRefundRequest request, RequestOptions requestOptions) {
        return this.rawClient.dismissTerminalRefund(request, requestOptions).thenApply(response -> (DismissTerminalRefundResponse)response.body());
    }

    public AsyncActionsClient actions() {
        return this.actionsClient.get();
    }

    public AsyncCheckoutsClient checkouts() {
        return this.checkoutsClient.get();
    }

    public AsyncRefundsClient refunds() {
        return this.refundsClient.get();
    }
}

