/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawV1TransactionsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.V1ListOrdersRequest;
import com.squareup.square.types.V1Order;
import com.squareup.square.types.V1RetrieveOrderRequest;
import com.squareup.square.types.V1UpdateOrderRequest;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncV1TransactionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawV1TransactionsClient rawClient;

    public AsyncV1TransactionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawV1TransactionsClient(clientOptions);
    }

    public AsyncRawV1TransactionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<V1Order>> v1ListOrders(V1ListOrdersRequest request) {
        return this.rawClient.v1ListOrders(request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<V1Order>> v1ListOrders(V1ListOrdersRequest request, RequestOptions requestOptions) {
        return this.rawClient.v1ListOrders(request, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<V1Order> v1RetrieveOrder(V1RetrieveOrderRequest request) {
        return this.rawClient.v1RetrieveOrder(request).thenApply(response -> (V1Order)response.body());
    }

    public CompletableFuture<V1Order> v1RetrieveOrder(V1RetrieveOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.v1RetrieveOrder(request, requestOptions).thenApply(response -> (V1Order)response.body());
    }

    public CompletableFuture<V1Order> v1UpdateOrder(V1UpdateOrderRequest request) {
        return this.rawClient.v1UpdateOrder(request).thenApply(response -> (V1Order)response.body());
    }

    public CompletableFuture<V1Order> v1UpdateOrder(V1UpdateOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.v1UpdateOrder(request, requestOptions).thenApply(response -> (V1Order)response.body());
    }
}

