/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawCardsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.Card;
import com.squareup.square.types.CreateCardRequest;
import com.squareup.square.types.CreateCardResponse;
import com.squareup.square.types.DisableCardResponse;
import com.squareup.square.types.DisableCardsRequest;
import com.squareup.square.types.GetCardResponse;
import com.squareup.square.types.GetCardsRequest;
import com.squareup.square.types.ListCardsRequest;

public class CardsClient {
    protected final ClientOptions clientOptions;
    private final RawCardsClient rawClient;

    public CardsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCardsClient(clientOptions);
    }

    public RawCardsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Card> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Card> list(ListCardsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Card> list(ListCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateCardResponse create(CreateCardRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateCardResponse create(CreateCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GetCardResponse get(GetCardsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetCardResponse get(GetCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public DisableCardResponse disable(DisableCardsRequest request) {
        return this.rawClient.disable(request).body();
    }

    public DisableCardResponse disable(DisableCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.disable(request, requestOptions).body();
    }
}

