/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawCheckoutClient;
import com.squareup.square.checkout.PaymentLinksClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.types.RetrieveLocationSettingsRequest;
import com.squareup.square.types.RetrieveLocationSettingsResponse;
import com.squareup.square.types.RetrieveMerchantSettingsResponse;
import com.squareup.square.types.UpdateLocationSettingsRequest;
import com.squareup.square.types.UpdateLocationSettingsResponse;
import com.squareup.square.types.UpdateMerchantSettingsRequest;
import com.squareup.square.types.UpdateMerchantSettingsResponse;
import java.util.function.Supplier;

public class CheckoutClient {
    protected final ClientOptions clientOptions;
    private final RawCheckoutClient rawClient;
    protected final Supplier<PaymentLinksClient> paymentLinksClient;

    public CheckoutClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCheckoutClient(clientOptions);
        this.paymentLinksClient = Suppliers.memoize(() -> new PaymentLinksClient(clientOptions));
    }

    public RawCheckoutClient withRawResponse() {
        return this.rawClient;
    }

    public RetrieveLocationSettingsResponse retrieveLocationSettings(RetrieveLocationSettingsRequest request) {
        return this.rawClient.retrieveLocationSettings(request).body();
    }

    public RetrieveLocationSettingsResponse retrieveLocationSettings(RetrieveLocationSettingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveLocationSettings(request, requestOptions).body();
    }

    public UpdateLocationSettingsResponse updateLocationSettings(UpdateLocationSettingsRequest request) {
        return this.rawClient.updateLocationSettings(request).body();
    }

    public UpdateLocationSettingsResponse updateLocationSettings(UpdateLocationSettingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateLocationSettings(request, requestOptions).body();
    }

    public RetrieveMerchantSettingsResponse retrieveMerchantSettings() {
        return this.rawClient.retrieveMerchantSettings().body();
    }

    public RetrieveMerchantSettingsResponse retrieveMerchantSettings(RequestOptions requestOptions) {
        return this.rawClient.retrieveMerchantSettings(requestOptions).body();
    }

    public UpdateMerchantSettingsResponse updateMerchantSettings(UpdateMerchantSettingsRequest request) {
        return this.rawClient.updateMerchantSettings(request).body();
    }

    public UpdateMerchantSettingsResponse updateMerchantSettings(UpdateMerchantSettingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateMerchantSettings(request, requestOptions).body();
    }

    public PaymentLinksClient paymentLinks() {
        return this.paymentLinksClient.get();
    }
}

