/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawLocationsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.locations.CustomAttributeDefinitionsClient;
import com.squareup.square.locations.CustomAttributesClient;
import com.squareup.square.locations.TransactionsClient;
import com.squareup.square.types.CreateCheckoutRequest;
import com.squareup.square.types.CreateCheckoutResponse;
import com.squareup.square.types.CreateLocationRequest;
import com.squareup.square.types.CreateLocationResponse;
import com.squareup.square.types.GetLocationResponse;
import com.squareup.square.types.GetLocationsRequest;
import com.squareup.square.types.ListLocationsResponse;
import com.squareup.square.types.UpdateLocationRequest;
import com.squareup.square.types.UpdateLocationResponse;
import java.util.function.Supplier;

public class LocationsClient {
    protected final ClientOptions clientOptions;
    private final RawLocationsClient rawClient;
    protected final Supplier<CustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<CustomAttributesClient> customAttributesClient;
    protected final Supplier<TransactionsClient> transactionsClient;

    public LocationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawLocationsClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new CustomAttributeDefinitionsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new CustomAttributesClient(clientOptions));
        this.transactionsClient = Suppliers.memoize(() -> new TransactionsClient(clientOptions));
    }

    public RawLocationsClient withRawResponse() {
        return this.rawClient;
    }

    public ListLocationsResponse list() {
        return this.rawClient.list().body();
    }

    public ListLocationsResponse list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public CreateLocationResponse create() {
        return this.rawClient.create().body();
    }

    public CreateLocationResponse create(CreateLocationRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateLocationResponse create(CreateLocationRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GetLocationResponse get(GetLocationsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetLocationResponse get(GetLocationsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public UpdateLocationResponse update(UpdateLocationRequest request) {
        return this.rawClient.update(request).body();
    }

    public UpdateLocationResponse update(UpdateLocationRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public CreateCheckoutResponse checkouts(CreateCheckoutRequest request) {
        return this.rawClient.checkouts(request).body();
    }

    public CreateCheckoutResponse checkouts(CreateCheckoutRequest request, RequestOptions requestOptions) {
        return this.rawClient.checkouts(request, requestOptions).body();
    }

    public CustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public CustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }

    public TransactionsClient transactions() {
        return this.transactionsClient.get();
    }
}

