/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawLoyaltyClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.loyalty.AccountsClient;
import com.squareup.square.loyalty.ProgramsClient;
import com.squareup.square.loyalty.RewardsClient;
import com.squareup.square.types.SearchLoyaltyEventsRequest;
import com.squareup.square.types.SearchLoyaltyEventsResponse;
import java.util.function.Supplier;

public class LoyaltyClient {
    protected final ClientOptions clientOptions;
    private final RawLoyaltyClient rawClient;
    protected final Supplier<AccountsClient> accountsClient;
    protected final Supplier<ProgramsClient> programsClient;
    protected final Supplier<RewardsClient> rewardsClient;

    public LoyaltyClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawLoyaltyClient(clientOptions);
        this.accountsClient = Suppliers.memoize(() -> new AccountsClient(clientOptions));
        this.programsClient = Suppliers.memoize(() -> new ProgramsClient(clientOptions));
        this.rewardsClient = Suppliers.memoize(() -> new RewardsClient(clientOptions));
    }

    public RawLoyaltyClient withRawResponse() {
        return this.rawClient;
    }

    public SearchLoyaltyEventsResponse searchEvents() {
        return this.rawClient.searchEvents().body();
    }

    public SearchLoyaltyEventsResponse searchEvents(SearchLoyaltyEventsRequest request) {
        return this.rawClient.searchEvents(request).body();
    }

    public SearchLoyaltyEventsResponse searchEvents(SearchLoyaltyEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchEvents(request, requestOptions).body();
    }

    public AccountsClient accounts() {
        return this.accountsClient.get();
    }

    public ProgramsClient programs() {
        return this.programsClient.get();
    }

    public RewardsClient rewards() {
        return this.rewardsClient.get();
    }
}

