/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.AcceptDisputeResponse;
import com.squareup.square.types.AcceptDisputesRequest;
import com.squareup.square.types.CreateDisputeEvidenceFileResponse;
import com.squareup.square.types.CreateDisputeEvidenceTextRequest;
import com.squareup.square.types.CreateDisputeEvidenceTextResponse;
import com.squareup.square.types.CreateEvidenceFileDisputesRequest;
import com.squareup.square.types.Dispute;
import com.squareup.square.types.GetDisputeResponse;
import com.squareup.square.types.GetDisputesRequest;
import com.squareup.square.types.ListDisputesRequest;
import com.squareup.square.types.ListDisputesResponse;
import com.squareup.square.types.SubmitEvidenceDisputesRequest;
import com.squareup.square.types.SubmitEvidenceResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawDisputesClient {
    protected final ClientOptions clientOptions;

    public RawDisputesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<Dispute>> list() {
        return this.list(ListDisputesRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<Dispute>> list(ListDisputesRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<Dispute>> list(ListDisputesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/disputes");
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getStates().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "states", request.getStates().get(), false);
        }
        if (request.getLocationId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListDisputesResponse parsedResponse = (ListDisputesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListDisputesResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListDisputesRequest nextRequest = ListDisputesRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getDisputes().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<Dispute>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<Dispute>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetDisputeResponse> get(GetDisputesRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetDisputeResponse> get(GetDisputesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/disputes").addPathSegment(request.getDisputeId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetDisputeResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetDisputeResponse>((GetDisputeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetDisputeResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<AcceptDisputeResponse> accept(AcceptDisputesRequest request) {
        return this.accept(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<AcceptDisputeResponse> accept(AcceptDisputesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/disputes").addPathSegment(request.getDisputeId()).addPathSegments("accept").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<AcceptDisputeResponse> squareClientHttpResponse = new SquareClientHttpResponse<AcceptDisputeResponse>((AcceptDisputeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), AcceptDisputeResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CreateDisputeEvidenceFileResponse> createEvidenceFile(CreateEvidenceFileDisputesRequest request) {
        return this.createEvidenceFile(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateDisputeEvidenceFileResponse> createEvidenceFile(CreateEvidenceFileDisputesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/disputes").addPathSegment(request.getDisputeId()).addPathSegments("evidence-files").build();
        MultipartBody.Builder body = new MultipartBody.Builder().setType(MultipartBody.FORM);
        try {
            if (request.getRequest().isPresent()) {
                body.addFormDataPart("request", ObjectMappers.JSON_MAPPER.writeValueAsString((Object)request.getRequest().get()));
            }
            if (request.getImageFile().isPresent()) {
                String imageFileMimeType = Files.probeContentType(request.getImageFile().get().toPath());
                MediaType imageFileMimeTypeMediaType = imageFileMimeType != null ? MediaType.parse((String)imageFileMimeType) : null;
                body.addFormDataPart("image_file", request.getImageFile().get().getName(), RequestBody.create((File)request.getImageFile().get(), (MediaType)imageFileMimeTypeMediaType));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", (RequestBody)body.build()).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateDisputeEvidenceFileResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateDisputeEvidenceFileResponse>((CreateDisputeEvidenceFileResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateDisputeEvidenceFileResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CreateDisputeEvidenceTextResponse> createEvidenceText(CreateDisputeEvidenceTextRequest request) {
        return this.createEvidenceText(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateDisputeEvidenceTextResponse> createEvidenceText(CreateDisputeEvidenceTextRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/disputes").addPathSegment(request.getDisputeId()).addPathSegments("evidence-text").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateDisputeEvidenceTextResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateDisputeEvidenceTextResponse>((CreateDisputeEvidenceTextResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateDisputeEvidenceTextResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SubmitEvidenceResponse> submitEvidence(SubmitEvidenceDisputesRequest request) {
        return this.submitEvidence(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SubmitEvidenceResponse> submitEvidence(SubmitEvidenceDisputesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/disputes").addPathSegment(request.getDisputeId()).addPathSegments("submit-evidence").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<SubmitEvidenceResponse> squareClientHttpResponse = new SquareClientHttpResponse<SubmitEvidenceResponse>((SubmitEvidenceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SubmitEvidenceResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

