/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.types.V1ListOrdersRequest;
import com.squareup.square.types.V1Order;
import com.squareup.square.types.V1RetrieveOrderRequest;
import com.squareup.square.types.V1UpdateOrderRequest;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawV1TransactionsClient {
    protected final ClientOptions clientOptions;

    public RawV1TransactionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<List<V1Order>> v1ListOrders(V1ListOrdersRequest request) {
        return this.v1ListOrders(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<List<V1Order>> v1ListOrders(V1ListOrdersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1").addPathSegment(request.getLocationId()).addPathSegments("orders");
        if (request.getOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "order", request.getOrder().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getBatchToken().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "batch_token", request.getBatchToken().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<List<V1Order>> squareClientHttpResponse = new SquareClientHttpResponse<List<V1Order>>((List)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<List<V1Order>>(){}), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<V1Order> v1RetrieveOrder(V1RetrieveOrderRequest request) {
        return this.v1RetrieveOrder(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<V1Order> v1RetrieveOrder(V1RetrieveOrderRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1").addPathSegment(request.getLocationId()).addPathSegments("orders").addPathSegment(request.getOrderId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<V1Order> squareClientHttpResponse = new SquareClientHttpResponse<V1Order>((V1Order)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), V1Order.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<V1Order> v1UpdateOrder(V1UpdateOrderRequest request) {
        return this.v1UpdateOrder(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<V1Order> v1UpdateOrder(V1UpdateOrderRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1").addPathSegment(request.getLocationId()).addPathSegments("orders").addPathSegment(request.getOrderId()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<V1Order> squareClientHttpResponse = new SquareClientHttpResponse<V1Order>((V1Order)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), V1Order.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

