/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.SquareClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.Environment;
import okhttp3.OkHttpClient;

public final class SquareClientBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String token = System.getenv("SQUARE_TOKEN");
    private String version = "2025-06-18";
    private Environment environment = Environment.PRODUCTION;

    public SquareClientBuilder token(String token) {
        this.token = token;
        return this;
    }

    public SquareClientBuilder version(String version) {
        this.version = version;
        return this;
    }

    public SquareClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public SquareClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public SquareClientBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public SquareClientBuilder maxRetries(int maxRetries) {
        this.clientOptionsBuilder.maxRetries(maxRetries);
        return this;
    }

    public SquareClientBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public SquareClient build() {
        this.clientOptionsBuilder.addHeader("Authorization", "Bearer " + this.token);
        this.clientOptionsBuilder.addHeader("Square-Version", this.version);
        this.clientOptionsBuilder.environment(this.environment);
        return new SquareClient(this.clientOptionsBuilder.build());
    }
}

