/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawTerminalClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.terminal.ActionsClient;
import com.squareup.square.terminal.CheckoutsClient;
import com.squareup.square.terminal.RefundsClient;
import com.squareup.square.types.DismissTerminalActionRequest;
import com.squareup.square.types.DismissTerminalActionResponse;
import com.squareup.square.types.DismissTerminalCheckoutRequest;
import com.squareup.square.types.DismissTerminalCheckoutResponse;
import com.squareup.square.types.DismissTerminalRefundRequest;
import com.squareup.square.types.DismissTerminalRefundResponse;
import java.util.function.Supplier;

public class TerminalClient {
    protected final ClientOptions clientOptions;
    private final RawTerminalClient rawClient;
    protected final Supplier<ActionsClient> actionsClient;
    protected final Supplier<CheckoutsClient> checkoutsClient;
    protected final Supplier<RefundsClient> refundsClient;

    public TerminalClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTerminalClient(clientOptions);
        this.actionsClient = Suppliers.memoize(() -> new ActionsClient(clientOptions));
        this.checkoutsClient = Suppliers.memoize(() -> new CheckoutsClient(clientOptions));
        this.refundsClient = Suppliers.memoize(() -> new RefundsClient(clientOptions));
    }

    public RawTerminalClient withRawResponse() {
        return this.rawClient;
    }

    public DismissTerminalActionResponse dismissTerminalAction(DismissTerminalActionRequest request) {
        return this.rawClient.dismissTerminalAction(request).body();
    }

    public DismissTerminalActionResponse dismissTerminalAction(DismissTerminalActionRequest request, RequestOptions requestOptions) {
        return this.rawClient.dismissTerminalAction(request, requestOptions).body();
    }

    public DismissTerminalCheckoutResponse dismissTerminalCheckout(DismissTerminalCheckoutRequest request) {
        return this.rawClient.dismissTerminalCheckout(request).body();
    }

    public DismissTerminalCheckoutResponse dismissTerminalCheckout(DismissTerminalCheckoutRequest request, RequestOptions requestOptions) {
        return this.rawClient.dismissTerminalCheckout(request, requestOptions).body();
    }

    public DismissTerminalRefundResponse dismissTerminalRefund(DismissTerminalRefundRequest request) {
        return this.rawClient.dismissTerminalRefund(request).body();
    }

    public DismissTerminalRefundResponse dismissTerminalRefund(DismissTerminalRefundRequest request, RequestOptions requestOptions) {
        return this.rawClient.dismissTerminalRefund(request, requestOptions).body();
    }

    public ActionsClient actions() {
        return this.actionsClient.get();
    }

    public CheckoutsClient checkouts() {
        return this.checkoutsClient.get();
    }

    public RefundsClient refunds() {
        return this.refundsClient.get();
    }
}

