/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.bookings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.bookings.types.CreateBookingCustomAttributeDefinitionRequest;
import com.squareup.square.bookings.types.DeleteCustomAttributeDefinitionsRequest;
import com.squareup.square.bookings.types.GetCustomAttributeDefinitionsRequest;
import com.squareup.square.bookings.types.ListCustomAttributeDefinitionsRequest;
import com.squareup.square.bookings.types.UpdateBookingCustomAttributeDefinitionRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CreateBookingCustomAttributeDefinitionResponse;
import com.squareup.square.types.CustomAttributeDefinition;
import com.squareup.square.types.DeleteBookingCustomAttributeDefinitionResponse;
import com.squareup.square.types.ListBookingCustomAttributeDefinitionsResponse;
import com.squareup.square.types.RetrieveBookingCustomAttributeDefinitionResponse;
import com.squareup.square.types.UpdateBookingCustomAttributeDefinitionResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawCustomAttributeDefinitionsClient {
    protected final ClientOptions clientOptions;

    public RawCustomAttributeDefinitionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list() {
        return this.list(ListCustomAttributeDefinitionsRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/custom-attribute-definitions");
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListBookingCustomAttributeDefinitionsResponse parsedResponse = (ListBookingCustomAttributeDefinitionsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListBookingCustomAttributeDefinitionsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListCustomAttributeDefinitionsRequest nextRequest = ListCustomAttributeDefinitionsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getCustomAttributeDefinitions().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CreateBookingCustomAttributeDefinitionResponse> create(CreateBookingCustomAttributeDefinitionRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateBookingCustomAttributeDefinitionResponse> create(CreateBookingCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/custom-attribute-definitions").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateBookingCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateBookingCustomAttributeDefinitionResponse>((CreateBookingCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateBookingCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<RetrieveBookingCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<RetrieveBookingCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/custom-attribute-definitions").addPathSegment(request.getKey());
        if (request.getVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "version", request.getVersion().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<RetrieveBookingCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<RetrieveBookingCustomAttributeDefinitionResponse>((RetrieveBookingCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), RetrieveBookingCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpdateBookingCustomAttributeDefinitionResponse> update(UpdateBookingCustomAttributeDefinitionRequest request) {
        return this.update(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpdateBookingCustomAttributeDefinitionResponse> update(UpdateBookingCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/custom-attribute-definitions").addPathSegment(request.getKey()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpdateBookingCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpdateBookingCustomAttributeDefinitionResponse>((UpdateBookingCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateBookingCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<DeleteBookingCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request) {
        return this.delete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<DeleteBookingCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/custom-attribute-definitions").addPathSegment(request.getKey()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<DeleteBookingCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<DeleteBookingCustomAttributeDefinitionResponse>((DeleteBookingCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteBookingCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

