/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.bookings;

import com.squareup.square.bookings.types.ListLocationProfilesRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.ListLocationBookingProfilesResponse;
import com.squareup.square.types.LocationBookingProfile;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawLocationProfilesClient {
    protected final ClientOptions clientOptions;

    public RawLocationProfilesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<LocationBookingProfile>> list() {
        return this.list(ListLocationProfilesRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<LocationBookingProfile>> list(ListLocationProfilesRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<LocationBookingProfile>> list(ListLocationProfilesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/location-booking-profiles");
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListLocationBookingProfilesResponse parsedResponse = (ListLocationBookingProfilesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListLocationBookingProfilesResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListLocationProfilesRequest nextRequest = ListLocationProfilesRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getLocationBookingProfiles().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<LocationBookingProfile>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<LocationBookingProfile>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

