/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.cashdrawers;

import com.squareup.square.cashdrawers.AsyncRawShiftsClient;
import com.squareup.square.cashdrawers.types.GetShiftsRequest;
import com.squareup.square.cashdrawers.types.ListEventsShiftsRequest;
import com.squareup.square.cashdrawers.types.ListShiftsRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CashDrawerShiftEvent;
import com.squareup.square.types.CashDrawerShiftSummary;
import com.squareup.square.types.GetCashDrawerShiftResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncShiftsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawShiftsClient rawClient;

    public AsyncShiftsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShiftsClient(clientOptions);
    }

    public AsyncRawShiftsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<CashDrawerShiftSummary>> list(ListShiftsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CashDrawerShiftSummary>> list(ListShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetCashDrawerShiftResponse> get(GetShiftsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetCashDrawerShiftResponse)response.body());
    }

    public CompletableFuture<GetCashDrawerShiftResponse> get(GetShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetCashDrawerShiftResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CashDrawerShiftEvent>> listEvents(ListEventsShiftsRequest request) {
        return this.rawClient.listEvents(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CashDrawerShiftEvent>> listEvents(ListEventsShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEvents(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }
}

