/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.cashdrawers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetShiftsRequest {
    private final String shiftId;
    private final String locationId;
    private final Map<String, Object> additionalProperties;

    private GetShiftsRequest(String shiftId, String locationId, Map<String, Object> additionalProperties) {
        this.shiftId = shiftId;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="shift_id")
    public String getShiftId() {
        return this.shiftId;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetShiftsRequest && this.equalTo((GetShiftsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetShiftsRequest other) {
        return this.shiftId.equals(other.shiftId) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.shiftId, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ShiftIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ShiftIdStage,
    LocationIdStage,
    _FinalStage {
        private String shiftId;
        private String locationId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetShiftsRequest other) {
            this.shiftId(other.getShiftId());
            this.locationId(other.getLocationId());
            return this;
        }

        @Override
        @JsonSetter(value="shift_id")
        public LocationIdStage shiftId(@NotNull String shiftId) {
            this.shiftId = Objects.requireNonNull(shiftId, "shiftId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public GetShiftsRequest build() {
            return new GetShiftsRequest(this.shiftId, this.locationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetShiftsRequest build();
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);
    }

    public static interface ShiftIdStage {
        public LocationIdStage shiftId(@NotNull String var1);

        public Builder from(GetShiftsRequest var1);
    }
}

