/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.cashdrawers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEventsShiftsRequest {
    private final String shiftId;
    private final String locationId;
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListEventsShiftsRequest(String shiftId, String locationId, Optional<Integer> limit, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.shiftId = shiftId;
        this.locationId = locationId;
        this.limit = limit;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="shift_id")
    public String getShiftId() {
        return this.shiftId;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEventsShiftsRequest && this.equalTo((ListEventsShiftsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventsShiftsRequest other) {
        return this.shiftId.equals(other.shiftId) && this.locationId.equals(other.locationId) && this.limit.equals(other.limit) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.shiftId, this.locationId, this.limit, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ShiftIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ShiftIdStage,
    LocationIdStage,
    _FinalStage {
        private String shiftId;
        private String locationId;
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListEventsShiftsRequest other) {
            this.shiftId(other.getShiftId());
            this.locationId(other.getLocationId());
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            return this;
        }

        @Override
        @JsonSetter(value="shift_id")
        public LocationIdStage shiftId(@NotNull String shiftId) {
            this.shiftId = Objects.requireNonNull(shiftId, "shiftId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public _FinalStage cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public _FinalStage limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public ListEventsShiftsRequest build() {
            return new ListEventsShiftsRequest(this.shiftId, this.locationId, this.limit, this.cursor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListEventsShiftsRequest build();

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage limit(Nullable<Integer> var1);

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);

        public _FinalStage cursor(Nullable<String> var1);
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);
    }

    public static interface ShiftIdStage {
        public LocationIdStage shiftId(@NotNull String var1);

        public Builder from(ListEventsShiftsRequest var1);
    }
}

