/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.cashdrawers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListShiftsRequest {
    private final String locationId;
    private final Optional<SortOrder> sortOrder;
    private final Optional<String> beginTime;
    private final Optional<String> endTime;
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListShiftsRequest(String locationId, Optional<SortOrder> sortOrder, Optional<String> beginTime, Optional<String> endTime, Optional<Integer> limit, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.sortOrder = sortOrder;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.limit = limit;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<SortOrder> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<String> getBeginTime() {
        if (this.beginTime == null) {
            return Optional.empty();
        }
        return this.beginTime;
    }

    @JsonIgnore
    public Optional<String> getEndTime() {
        if (this.endTime == null) {
            return Optional.empty();
        }
        return this.endTime;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<SortOrder> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="begin_time")
    private Optional<String> _getBeginTime() {
        return this.beginTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_time")
    private Optional<String> _getEndTime() {
        return this.endTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListShiftsRequest && this.equalTo((ListShiftsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListShiftsRequest other) {
        return this.locationId.equals(other.locationId) && this.sortOrder.equals(other.sortOrder) && this.beginTime.equals(other.beginTime) && this.endTime.equals(other.endTime) && this.limit.equals(other.limit) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.sortOrder, this.beginTime, this.endTime, this.limit, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    _FinalStage {
        private String locationId;
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> endTime = Optional.empty();
        private Optional<String> beginTime = Optional.empty();
        private Optional<SortOrder> sortOrder = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListShiftsRequest other) {
            this.locationId(other.getLocationId());
            this.sortOrder(other.getSortOrder());
            this.beginTime(other.getBeginTime());
            this.endTime(other.getEndTime());
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public _FinalStage cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public _FinalStage limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage endTime(Nullable<String> endTime) {
            this.endTime = endTime.isNull() ? null : (endTime.isEmpty() ? Optional.empty() : Optional.of(endTime.get()));
            return this;
        }

        @Override
        public _FinalStage endTime(String endTime) {
            this.endTime = Optional.ofNullable(endTime);
            return this;
        }

        @Override
        @JsonSetter(value="end_time", nulls=Nulls.SKIP)
        public _FinalStage endTime(Optional<String> endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public _FinalStage beginTime(Nullable<String> beginTime) {
            this.beginTime = beginTime.isNull() ? null : (beginTime.isEmpty() ? Optional.empty() : Optional.of(beginTime.get()));
            return this;
        }

        @Override
        public _FinalStage beginTime(String beginTime) {
            this.beginTime = Optional.ofNullable(beginTime);
            return this;
        }

        @Override
        @JsonSetter(value="begin_time", nulls=Nulls.SKIP)
        public _FinalStage beginTime(Optional<String> beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        @Override
        public _FinalStage sortOrder(Nullable<SortOrder> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @Override
        public _FinalStage sortOrder(SortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @Override
        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public _FinalStage sortOrder(Optional<SortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public ListShiftsRequest build() {
            return new ListShiftsRequest(this.locationId, this.sortOrder, this.beginTime, this.endTime, this.limit, this.cursor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListShiftsRequest build();

        public _FinalStage sortOrder(Optional<SortOrder> var1);

        public _FinalStage sortOrder(SortOrder var1);

        public _FinalStage sortOrder(Nullable<SortOrder> var1);

        public _FinalStage beginTime(Optional<String> var1);

        public _FinalStage beginTime(String var1);

        public _FinalStage beginTime(Nullable<String> var1);

        public _FinalStage endTime(Optional<String> var1);

        public _FinalStage endTime(String var1);

        public _FinalStage endTime(Nullable<String> var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage limit(Nullable<Integer> var1);

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);

        public _FinalStage cursor(Nullable<String> var1);
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);

        public Builder from(ListShiftsRequest var1);
    }
}

