/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.catalog;

import com.squareup.square.catalog.AsyncRawObjectClient;
import com.squareup.square.catalog.types.DeleteObjectRequest;
import com.squareup.square.catalog.types.GetObjectRequest;
import com.squareup.square.catalog.types.UpsertCatalogObjectRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.DeleteCatalogObjectResponse;
import com.squareup.square.types.GetCatalogObjectResponse;
import com.squareup.square.types.UpsertCatalogObjectResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncObjectClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawObjectClient rawClient;

    public AsyncObjectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawObjectClient(clientOptions);
    }

    public AsyncRawObjectClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<UpsertCatalogObjectResponse> upsert(UpsertCatalogObjectRequest request) {
        return this.rawClient.upsert(request).thenApply(response -> (UpsertCatalogObjectResponse)response.body());
    }

    public CompletableFuture<UpsertCatalogObjectResponse> upsert(UpsertCatalogObjectRequest request, RequestOptions requestOptions) {
        return this.rawClient.upsert(request, requestOptions).thenApply(response -> (UpsertCatalogObjectResponse)response.body());
    }

    public CompletableFuture<GetCatalogObjectResponse> get(GetObjectRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetCatalogObjectResponse)response.body());
    }

    public CompletableFuture<GetCatalogObjectResponse> get(GetObjectRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetCatalogObjectResponse)response.body());
    }

    public CompletableFuture<DeleteCatalogObjectResponse> delete(DeleteObjectRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteCatalogObjectResponse)response.body());
    }

    public CompletableFuture<DeleteCatalogObjectResponse> delete(DeleteObjectRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteCatalogObjectResponse)response.body());
    }
}

