/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.catalog;

import com.squareup.square.catalog.types.CreateImagesRequest;
import com.squareup.square.catalog.types.UpdateImagesRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.types.CreateCatalogImageResponse;
import com.squareup.square.types.UpdateCatalogImageResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawImagesClient {
    protected final ClientOptions clientOptions;

    public RawImagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<CreateCatalogImageResponse> create() {
        return this.create(CreateImagesRequest.builder().build());
    }

    public SquareClientHttpResponse<CreateCatalogImageResponse> create(CreateImagesRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateCatalogImageResponse> create(CreateImagesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/images").build();
        MultipartBody.Builder body = new MultipartBody.Builder().setType(MultipartBody.FORM);
        try {
            if (request.getRequest().isPresent()) {
                body.addFormDataPart("request", ObjectMappers.JSON_MAPPER.writeValueAsString((Object)request.getRequest().get()));
            }
            if (request.getImageFile().isPresent()) {
                String imageFileMimeType = Files.probeContentType(request.getImageFile().get().toPath());
                MediaType imageFileMimeTypeMediaType = imageFileMimeType != null ? MediaType.parse((String)imageFileMimeType) : null;
                body.addFormDataPart("image_file", request.getImageFile().get().getName(), RequestBody.create((File)request.getImageFile().get(), (MediaType)imageFileMimeTypeMediaType));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", (RequestBody)body.build()).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateCatalogImageResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateCatalogImageResponse>((CreateCatalogImageResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateCatalogImageResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpdateCatalogImageResponse> update(UpdateImagesRequest request) {
        return this.update(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpdateCatalogImageResponse> update(UpdateImagesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/images").addPathSegment(request.getImageId()).build();
        MultipartBody.Builder body = new MultipartBody.Builder().setType(MultipartBody.FORM);
        try {
            if (request.getRequest().isPresent()) {
                body.addFormDataPart("request", ObjectMappers.JSON_MAPPER.writeValueAsString((Object)request.getRequest().get()));
            }
            if (request.getImageFile().isPresent()) {
                String imageFileMimeType = Files.probeContentType(request.getImageFile().get().toPath());
                MediaType imageFileMimeTypeMediaType = imageFileMimeType != null ? MediaType.parse((String)imageFileMimeType) : null;
                body.addFormDataPart("image_file", request.getImageFile().get().getName(), RequestBody.create((File)request.getImageFile().get(), (MediaType)imageFileMimeTypeMediaType));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("PUT", (RequestBody)body.build()).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpdateCatalogImageResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpdateCatalogImageResponse>((UpdateCatalogImageResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateCatalogImageResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

