/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.catalog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.catalog.types.DeleteObjectRequest;
import com.squareup.square.catalog.types.GetObjectRequest;
import com.squareup.square.catalog.types.UpsertCatalogObjectRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.types.DeleteCatalogObjectResponse;
import com.squareup.square.types.GetCatalogObjectResponse;
import com.squareup.square.types.UpsertCatalogObjectResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawObjectClient {
    protected final ClientOptions clientOptions;

    public RawObjectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<UpsertCatalogObjectResponse> upsert(UpsertCatalogObjectRequest request) {
        return this.upsert(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpsertCatalogObjectResponse> upsert(UpsertCatalogObjectRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/object").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpsertCatalogObjectResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpsertCatalogObjectResponse>((UpsertCatalogObjectResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertCatalogObjectResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetCatalogObjectResponse> get(GetObjectRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetCatalogObjectResponse> get(GetObjectRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/object").addPathSegment(request.getObjectId());
        if (request.getIncludeRelatedObjects().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "include_related_objects", request.getIncludeRelatedObjects().get(), false);
        }
        if (request.getCatalogVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "catalog_version", request.getCatalogVersion().get(), false);
        }
        if (request.getIncludeCategoryPathToRoot().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "include_category_path_to_root", request.getIncludeCategoryPathToRoot().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetCatalogObjectResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetCatalogObjectResponse>((GetCatalogObjectResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCatalogObjectResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<DeleteCatalogObjectResponse> delete(DeleteObjectRequest request) {
        return this.delete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<DeleteCatalogObjectResponse> delete(DeleteObjectRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/object").addPathSegment(request.getObjectId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<DeleteCatalogObjectResponse> squareClientHttpResponse = new SquareClientHttpResponse<DeleteCatalogObjectResponse>((DeleteCatalogObjectResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteCatalogObjectResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

