/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.catalog.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CreateCatalogImageRequest;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateImagesRequest {
    private final Optional<File> imageFile;
    private final Optional<CreateCatalogImageRequest> request;
    private final Map<String, Object> additionalProperties;

    private CreateImagesRequest(Optional<File> imageFile, Optional<CreateCatalogImageRequest> request, Map<String, Object> additionalProperties) {
        this.imageFile = imageFile;
        this.request = request;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="image_file")
    public Optional<File> getImageFile() {
        return this.imageFile;
    }

    @JsonProperty(value="request")
    public Optional<CreateCatalogImageRequest> getRequest() {
        return this.request;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateImagesRequest && this.equalTo((CreateImagesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateImagesRequest other) {
        return this.imageFile.equals(other.imageFile) && this.request.equals(other.request);
    }

    public int hashCode() {
        return Objects.hash(this.imageFile, this.request);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<File> imageFile = Optional.empty();
        private Optional<CreateCatalogImageRequest> request = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateImagesRequest other) {
            this.imageFile(other.getImageFile());
            this.request(other.getRequest());
            return this;
        }

        @JsonSetter(value="image_file", nulls=Nulls.SKIP)
        public Builder imageFile(Optional<File> imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        public Builder imageFile(File imageFile) {
            this.imageFile = Optional.ofNullable(imageFile);
            return this;
        }

        @JsonSetter(value="request", nulls=Nulls.SKIP)
        public Builder request(Optional<CreateCatalogImageRequest> request) {
            this.request = request;
            return this;
        }

        public Builder request(CreateCatalogImageRequest request) {
            this.request = Optional.ofNullable(request);
            return this;
        }

        public CreateImagesRequest build() {
            return new CreateImagesRequest(this.imageFile, this.request, this.additionalProperties);
        }
    }
}

