/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.customers.AsyncRawCardsClient;
import com.squareup.square.customers.types.CreateCustomerCardRequest;
import com.squareup.square.customers.types.DeleteCardsRequest;
import com.squareup.square.types.CreateCustomerCardResponse;
import com.squareup.square.types.DeleteCustomerCardResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCardsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCardsClient rawClient;

    public AsyncCardsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCardsClient(clientOptions);
    }

    public AsyncRawCardsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateCustomerCardResponse> create(CreateCustomerCardRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateCustomerCardResponse)response.body());
    }

    public CompletableFuture<CreateCustomerCardResponse> create(CreateCustomerCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateCustomerCardResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerCardResponse> delete(DeleteCardsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteCustomerCardResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerCardResponse> delete(DeleteCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteCustomerCardResponse)response.body());
    }
}

