/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.types.BatchUpsertCustomerCustomAttributesRequest;
import com.squareup.square.customers.types.CreateCustomerCustomAttributeDefinitionRequest;
import com.squareup.square.customers.types.DeleteCustomAttributeDefinitionsRequest;
import com.squareup.square.customers.types.GetCustomAttributeDefinitionsRequest;
import com.squareup.square.customers.types.ListCustomAttributeDefinitionsRequest;
import com.squareup.square.customers.types.UpdateCustomerCustomAttributeDefinitionRequest;
import com.squareup.square.types.BatchUpsertCustomerCustomAttributesResponse;
import com.squareup.square.types.CreateCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.types.CustomAttributeDefinition;
import com.squareup.square.types.DeleteCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.types.GetCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.types.ListCustomerCustomAttributeDefinitionsResponse;
import com.squareup.square.types.UpdateCustomerCustomAttributeDefinitionResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawCustomAttributeDefinitionsClient {
    protected final ClientOptions clientOptions;

    public RawCustomAttributeDefinitionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list() {
        return this.list(ListCustomAttributeDefinitionsRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/custom-attribute-definitions");
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListCustomerCustomAttributeDefinitionsResponse parsedResponse = (ListCustomerCustomAttributeDefinitionsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCustomerCustomAttributeDefinitionsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListCustomAttributeDefinitionsRequest nextRequest = ListCustomAttributeDefinitionsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getCustomAttributeDefinitions().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CreateCustomerCustomAttributeDefinitionResponse> create(CreateCustomerCustomAttributeDefinitionRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateCustomerCustomAttributeDefinitionResponse> create(CreateCustomerCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/custom-attribute-definitions").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateCustomerCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateCustomerCustomAttributeDefinitionResponse>((CreateCustomerCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateCustomerCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetCustomerCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetCustomerCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/custom-attribute-definitions").addPathSegment(request.getKey());
        if (request.getVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "version", request.getVersion().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetCustomerCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetCustomerCustomAttributeDefinitionResponse>((GetCustomerCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCustomerCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpdateCustomerCustomAttributeDefinitionResponse> update(UpdateCustomerCustomAttributeDefinitionRequest request) {
        return this.update(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpdateCustomerCustomAttributeDefinitionResponse> update(UpdateCustomerCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/custom-attribute-definitions").addPathSegment(request.getKey()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpdateCustomerCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpdateCustomerCustomAttributeDefinitionResponse>((UpdateCustomerCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateCustomerCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<DeleteCustomerCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request) {
        return this.delete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<DeleteCustomerCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/custom-attribute-definitions").addPathSegment(request.getKey()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<DeleteCustomerCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<DeleteCustomerCustomAttributeDefinitionResponse>((DeleteCustomerCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteCustomerCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BatchUpsertCustomerCustomAttributesResponse> batchUpsert(BatchUpsertCustomerCustomAttributesRequest request) {
        return this.batchUpsert(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BatchUpsertCustomerCustomAttributesResponse> batchUpsert(BatchUpsertCustomerCustomAttributesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/custom-attributes/bulk-upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BatchUpsertCustomerCustomAttributesResponse> squareClientHttpResponse = new SquareClientHttpResponse<BatchUpsertCustomerCustomAttributesResponse>((BatchUpsertCustomerCustomAttributesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchUpsertCustomerCustomAttributesResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

