/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCustomAttributesRequest {
    private final String customerId;
    private final String key;
    private final Optional<Boolean> withDefinition;
    private final Optional<Integer> version;
    private final Map<String, Object> additionalProperties;

    private GetCustomAttributesRequest(String customerId, String key, Optional<Boolean> withDefinition, Optional<Integer> version, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.key = key;
        this.withDefinition = withDefinition;
        this.version = version;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public Optional<Boolean> getWithDefinition() {
        if (this.withDefinition == null) {
            return Optional.empty();
        }
        return this.withDefinition;
    }

    @JsonIgnore
    public Optional<Integer> getVersion() {
        if (this.version == null) {
            return Optional.empty();
        }
        return this.version;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="with_definition")
    private Optional<Boolean> _getWithDefinition() {
        return this.withDefinition;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="version")
    private Optional<Integer> _getVersion() {
        return this.version;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCustomAttributesRequest && this.equalTo((GetCustomAttributesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomAttributesRequest other) {
        return this.customerId.equals(other.customerId) && this.key.equals(other.key) && this.withDefinition.equals(other.withDefinition) && this.version.equals(other.version);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.key, this.withDefinition, this.version);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerIdStage,
    KeyStage,
    _FinalStage {
        private String customerId;
        private String key;
        private Optional<Integer> version = Optional.empty();
        private Optional<Boolean> withDefinition = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetCustomAttributesRequest other) {
            this.customerId(other.getCustomerId());
            this.key(other.getKey());
            this.withDefinition(other.getWithDefinition());
            this.version(other.getVersion());
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public KeyStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public _FinalStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        public _FinalStage version(Nullable<Integer> version) {
            this.version = version.isNull() ? null : (version.isEmpty() ? Optional.empty() : Optional.of(version.get()));
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage withDefinition(Nullable<Boolean> withDefinition) {
            this.withDefinition = withDefinition.isNull() ? null : (withDefinition.isEmpty() ? Optional.empty() : Optional.of(withDefinition.get()));
            return this;
        }

        @Override
        public _FinalStage withDefinition(Boolean withDefinition) {
            this.withDefinition = Optional.ofNullable(withDefinition);
            return this;
        }

        @Override
        @JsonSetter(value="with_definition", nulls=Nulls.SKIP)
        public _FinalStage withDefinition(Optional<Boolean> withDefinition) {
            this.withDefinition = withDefinition;
            return this;
        }

        @Override
        public GetCustomAttributesRequest build() {
            return new GetCustomAttributesRequest(this.customerId, this.key, this.withDefinition, this.version, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetCustomAttributesRequest build();

        public _FinalStage withDefinition(Optional<Boolean> var1);

        public _FinalStage withDefinition(Boolean var1);

        public _FinalStage withDefinition(Nullable<Boolean> var1);

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage version(Nullable<Integer> var1);
    }

    public static interface KeyStage {
        public _FinalStage key(@NotNull String var1);
    }

    public static interface CustomerIdStage {
        public KeyStage customerId(@NotNull String var1);

        public Builder from(GetCustomAttributesRequest var1);
    }
}

