/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateCustomerGroupRequest {
    private final String groupId;
    private final CustomerGroup group;
    private final Map<String, Object> additionalProperties;

    private UpdateCustomerGroupRequest(String groupId, CustomerGroup group, Map<String, Object> additionalProperties) {
        this.groupId = groupId;
        this.group = group;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group")
    public CustomerGroup getGroup() {
        return this.group;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateCustomerGroupRequest && this.equalTo((UpdateCustomerGroupRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCustomerGroupRequest other) {
        return this.groupId.equals(other.groupId) && this.group.equals(other.group);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.group);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GroupIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GroupIdStage,
    GroupStage,
    _FinalStage {
        private String groupId;
        private CustomerGroup group;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateCustomerGroupRequest other) {
            this.groupId(other.getGroupId());
            this.group(other.getGroup());
            return this;
        }

        @Override
        @JsonSetter(value="group_id")
        public GroupStage groupId(@NotNull String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="group")
        public _FinalStage group(@NotNull CustomerGroup group) {
            this.group = Objects.requireNonNull(group, "group must not be null");
            return this;
        }

        @Override
        public UpdateCustomerGroupRequest build() {
            return new UpdateCustomerGroupRequest(this.groupId, this.group, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateCustomerGroupRequest build();
    }

    public static interface GroupStage {
        public _FinalStage group(@NotNull CustomerGroup var1);
    }

    public static interface GroupIdStage {
        public GroupStage groupId(@NotNull String var1);

        public Builder from(UpdateCustomerGroupRequest var1);
    }
}

