/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.devices;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.devices.AsyncRawCodesClient;
import com.squareup.square.devices.types.CreateDeviceCodeRequest;
import com.squareup.square.devices.types.GetCodesRequest;
import com.squareup.square.devices.types.ListCodesRequest;
import com.squareup.square.types.CreateDeviceCodeResponse;
import com.squareup.square.types.DeviceCode;
import com.squareup.square.types.GetDeviceCodeResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCodesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCodesClient rawClient;

    public AsyncCodesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCodesClient(clientOptions);
    }

    public AsyncRawCodesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<DeviceCode>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<DeviceCode>> list(ListCodesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<DeviceCode>> list(ListCodesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateDeviceCodeResponse> create(CreateDeviceCodeRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateDeviceCodeResponse)response.body());
    }

    public CompletableFuture<CreateDeviceCodeResponse> create(CreateDeviceCodeRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateDeviceCodeResponse)response.body());
    }

    public CompletableFuture<GetDeviceCodeResponse> get(GetCodesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetDeviceCodeResponse)response.body());
    }

    public CompletableFuture<GetDeviceCodeResponse> get(GetCodesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetDeviceCodeResponse)response.body());
    }
}

