/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.devices.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeviceCodeStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCodesRequest {
    private final Optional<String> cursor;
    private final Optional<String> locationId;
    private final Optional<String> productType;
    private final Optional<DeviceCodeStatus> status;
    private final Map<String, Object> additionalProperties;

    private ListCodesRequest(Optional<String> cursor, Optional<String> locationId, Optional<String> productType, Optional<DeviceCodeStatus> status, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.locationId = locationId;
        this.productType = productType;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getProductType() {
        if (this.productType == null) {
            return Optional.empty();
        }
        return this.productType;
    }

    @JsonIgnore
    public Optional<DeviceCodeStatus> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="product_type")
    private Optional<String> _getProductType() {
        return this.productType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<DeviceCodeStatus> _getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCodesRequest && this.equalTo((ListCodesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCodesRequest other) {
        return this.cursor.equals(other.cursor) && this.locationId.equals(other.locationId) && this.productType.equals(other.productType) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.locationId, this.productType, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> productType = Optional.empty();
        private Optional<DeviceCodeStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCodesRequest other) {
            this.cursor(other.getCursor());
            this.locationId(other.getLocationId());
            this.productType(other.getProductType());
            this.status(other.getStatus());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="product_type", nulls=Nulls.SKIP)
        public Builder productType(Optional<String> productType) {
            this.productType = productType;
            return this;
        }

        public Builder productType(String productType) {
            this.productType = Optional.ofNullable(productType);
            return this;
        }

        public Builder productType(Nullable<String> productType) {
            this.productType = productType.isNull() ? null : (productType.isEmpty() ? Optional.empty() : Optional.of(productType.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<DeviceCodeStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(DeviceCodeStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Nullable<DeviceCodeStatus> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        public ListCodesRequest build() {
            return new ListCodesRequest(this.cursor, this.locationId, this.productType, this.status, this.additionalProperties);
        }
    }
}

