/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.disputes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteEvidenceRequest {
    private final String disputeId;
    private final String evidenceId;
    private final Map<String, Object> additionalProperties;

    private DeleteEvidenceRequest(String disputeId, String evidenceId, Map<String, Object> additionalProperties) {
        this.disputeId = disputeId;
        this.evidenceId = evidenceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="dispute_id")
    public String getDisputeId() {
        return this.disputeId;
    }

    @JsonProperty(value="evidence_id")
    public String getEvidenceId() {
        return this.evidenceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteEvidenceRequest && this.equalTo((DeleteEvidenceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteEvidenceRequest other) {
        return this.disputeId.equals(other.disputeId) && this.evidenceId.equals(other.evidenceId);
    }

    public int hashCode() {
        return Objects.hash(this.disputeId, this.evidenceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DisputeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DisputeIdStage,
    EvidenceIdStage,
    _FinalStage {
        private String disputeId;
        private String evidenceId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeleteEvidenceRequest other) {
            this.disputeId(other.getDisputeId());
            this.evidenceId(other.getEvidenceId());
            return this;
        }

        @Override
        @JsonSetter(value="dispute_id")
        public EvidenceIdStage disputeId(@NotNull String disputeId) {
            this.disputeId = Objects.requireNonNull(disputeId, "disputeId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="evidence_id")
        public _FinalStage evidenceId(@NotNull String evidenceId) {
            this.evidenceId = Objects.requireNonNull(evidenceId, "evidenceId must not be null");
            return this;
        }

        @Override
        public DeleteEvidenceRequest build() {
            return new DeleteEvidenceRequest(this.disputeId, this.evidenceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeleteEvidenceRequest build();
    }

    public static interface EvidenceIdStage {
        public _FinalStage evidenceId(@NotNull String var1);
    }

    public static interface DisputeIdStage {
        public EvidenceIdStage disputeId(@NotNull String var1);

        public Builder from(DeleteEvidenceRequest var1);
    }
}

