/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.disputes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEvidenceRequest {
    private final String disputeId;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListEvidenceRequest(String disputeId, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.disputeId = disputeId;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="dispute_id")
    public String getDisputeId() {
        return this.disputeId;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEvidenceRequest && this.equalTo((ListEvidenceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEvidenceRequest other) {
        return this.disputeId.equals(other.disputeId) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.disputeId, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DisputeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DisputeIdStage,
    _FinalStage {
        private String disputeId;
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListEvidenceRequest other) {
            this.disputeId(other.getDisputeId());
            this.cursor(other.getCursor());
            return this;
        }

        @Override
        @JsonSetter(value="dispute_id")
        public _FinalStage disputeId(@NotNull String disputeId) {
            this.disputeId = Objects.requireNonNull(disputeId, "disputeId must not be null");
            return this;
        }

        @Override
        public _FinalStage cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public ListEvidenceRequest build() {
            return new ListEvidenceRequest(this.disputeId, this.cursor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListEvidenceRequest build();

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);

        public _FinalStage cursor(Nullable<String> var1);
    }

    public static interface DisputeIdStage {
        public _FinalStage disputeId(@NotNull String var1);

        public Builder from(ListEvidenceRequest var1);
    }
}

