/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.giftcards;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.giftcards.AsyncRawActivitiesClient;
import com.squareup.square.giftcards.types.CreateGiftCardActivityRequest;
import com.squareup.square.giftcards.types.ListActivitiesRequest;
import com.squareup.square.types.CreateGiftCardActivityResponse;
import com.squareup.square.types.GiftCardActivity;
import java.util.concurrent.CompletableFuture;

public class AsyncActivitiesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawActivitiesClient rawClient;

    public AsyncActivitiesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawActivitiesClient(clientOptions);
    }

    public AsyncRawActivitiesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<GiftCardActivity>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<GiftCardActivity>> list(ListActivitiesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<GiftCardActivity>> list(ListActivitiesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateGiftCardActivityResponse> create(CreateGiftCardActivityRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateGiftCardActivityResponse)response.body());
    }

    public CompletableFuture<CreateGiftCardActivityResponse> create(CreateGiftCardActivityRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateGiftCardActivityResponse)response.body());
    }
}

