/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.labor;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.labor.AsyncRawShiftsClient;
import com.squareup.square.labor.types.CreateShiftRequest;
import com.squareup.square.labor.types.DeleteShiftsRequest;
import com.squareup.square.labor.types.GetShiftsRequest;
import com.squareup.square.labor.types.SearchShiftsRequest;
import com.squareup.square.labor.types.UpdateShiftRequest;
import com.squareup.square.types.CreateShiftResponse;
import com.squareup.square.types.DeleteShiftResponse;
import com.squareup.square.types.GetShiftResponse;
import com.squareup.square.types.SearchShiftsResponse;
import com.squareup.square.types.UpdateShiftResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncShiftsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawShiftsClient rawClient;

    public AsyncShiftsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShiftsClient(clientOptions);
    }

    public AsyncRawShiftsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateShiftResponse> create(CreateShiftRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateShiftResponse)response.body());
    }

    public CompletableFuture<CreateShiftResponse> create(CreateShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateShiftResponse)response.body());
    }

    public CompletableFuture<SearchShiftsResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchShiftsResponse)response.body());
    }

    public CompletableFuture<SearchShiftsResponse> search(SearchShiftsRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchShiftsResponse)response.body());
    }

    public CompletableFuture<SearchShiftsResponse> search(SearchShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchShiftsResponse)response.body());
    }

    public CompletableFuture<GetShiftResponse> get(GetShiftsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetShiftResponse)response.body());
    }

    public CompletableFuture<GetShiftResponse> get(GetShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetShiftResponse)response.body());
    }

    public CompletableFuture<UpdateShiftResponse> update(UpdateShiftRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateShiftResponse)response.body());
    }

    public CompletableFuture<UpdateShiftResponse> update(UpdateShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateShiftResponse)response.body());
    }

    public CompletableFuture<DeleteShiftResponse> delete(DeleteShiftsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteShiftResponse)response.body());
    }

    public CompletableFuture<DeleteShiftResponse> delete(DeleteShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteShiftResponse)response.body());
    }
}

